/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.common.controller;

import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.designtime.common.controller.AbstractDesignTimeController;
import cn.myapps.designtime.common.controller.Resource;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.util.Calendar;
import java.util.UUID;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/designtime/applications"})
@Scope(value="prototype")
public class UploadDesignTimeController
extends AbstractDesignTimeController {
    @PostMapping(value={"/uploads"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="\u6587\u4ef6\u4e0a\u4f20", notes="\u6587\u4ef6\u4e0a\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="multipartFiles", value="\u591a\u4e2a\u6587\u4ef6", required=true, paramType="query", dataType="string")})
    public Resource upload(@RequestParam(value="file") MultipartFile[] multipartFiles) throws Exception {
        String savePath = "";
        String fileName = "";
        String extName = "";
        ParamsTable params = this.getParams();
        boolean icon = params.getParameterAsBoolean("icon");
        String path = params.getParameterAsString("path");
        int year = 0;
        Calendar cal = Calendar.getInstance();
        year = cal.get(1);
        String id = UUID.randomUUID().toString();
        JSONArray result = new JSONArray();
        if (multipartFiles.length > 0) {
            for (int i = 0; i < multipartFiles.length; ++i) {
                File f;
                MultipartFile multipartFile = multipartFiles[i];
                fileName = multipartFile.getOriginalFilename();
                extName = fileName.substring(fileName.indexOf(".") + 1);
                if (StringUtil.isBlank((String)path)) {
                    savePath = PropertyUtil.getPath() + "/uploads/";
                    savePath = savePath + year;
                } else {
                    savePath = PropertyUtil.getPath() + path + "/";
                }
                File dir = new File(savePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if (fileName.indexOf("/") >= 0 || fileName.indexOf("\\") >= 0) {
                    throw new OBPMValidateException("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u79f0\u4e0d\u5408\u6cd5\uff01");
                }
                if (this.isNotLegalFileExt(extName)) {
                    return this.error(4001, "\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u4e0d\u5408\u6cd5\uff01", null);
                }
                if (!icon) {
                    f = new File(savePath + "/" + id + "." + extName);
                } else {
                    f = new File(savePath + "/" + fileName);
                    if (f.exists()) {
                        f.delete();
                    }
                }
                f.createNewFile();
                multipartFile.transferTo(f);
            }
            JSONObject responseInfoItem = new JSONObject();
            responseInfoItem.put((Object)"fileName", (Object)fileName);
            if (!icon) {
                responseInfoItem.put((Object)"filePath", (Object)("/uploads/" + year + "/" + id + "." + extName));
            } else {
                responseInfoItem.put((Object)"filePath", (Object)(path + "/" + fileName));
            }
            result.add((Object)responseInfoItem);
        }
        return this.success("ok", result);
    }

    private boolean isNotLegalFileExt(String fileExt) throws Exception {
        String[] excludeTypes = new String[]{"jsp", "class", "jspx"};
        if (StringUtil.isBlank((String)fileExt)) {
            return true;
        }
        String fileType = fileExt;
        for (int i = 0; i < excludeTypes.length; ++i) {
            String excludeType = excludeTypes[i];
            if (StringUtil.isBlank((String)excludeType) || !fileType.equalsIgnoreCase(excludeType)) continue;
            return true;
        }
        return false;
    }
}

