/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.designtime.common.controller;

import cn.myapps.designtime.common.controller.ErrorMessage;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@ApiModel
public class Resource
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    private static final long serialVersionUID = 2315158311944949185L;
    @ApiModelProperty(name="errcode", value="\u8fd4\u56de\u72b6\u6001\u7801")
    private int errcode;
    @ApiModelProperty(name="errmsg", value="\u8fd4\u56de\u4fe1\u606f")
    private String errmsg;
    @ApiModelProperty(name="data", value="\u8fd4\u56de\u7684json\u6570\u636e")
    private Object data;
    @ApiModelProperty(name="errors", value="\u9519\u8bef\u4fe1\u606f")
    private Collection<ErrorMessage> errors;

    public Resource() {
    }

    public Resource(int errcode, String errmsg, Object data, Collection<ErrorMessage> errors) {
        this(errcode, errmsg, data);
        this.errors = errors;
    }

    public Resource(int errcode, String errmsg, Object data) {
        this(errcode, errmsg);
        this.data = data;
        this.errors = null;
    }

    public Resource(int errcode, String errmsg) {
        this.errcode = errcode;
        this.errmsg = errmsg;
        this.data = null;
        this.errors = null;
        if (errcode > 0) {
            this.errmsg = "\u7cfb\u7edf\u5f02\u5e38";
            logger.error("\u7cfb\u7edf\u5f02\u5e38:{}", (Object)errmsg);
        }
    }

    public int getErrcode() {
        return this.errcode;
    }

    public void setErrcode(int errcode) {
        this.errcode = errcode;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Collection<ErrorMessage> getErrors() {
        return this.errors;
    }

    public void setErrors(Collection<ErrorMessage> errors) {
        this.errors = errors;
    }
}

