package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

import java.util.Date;

@Getter
public class UpdateCredentialCommand extends CommandAbstract {
    private final String id;
    private final String headPhoto;
    private final String frontPhoto;
    private final String reversePhoto;
    private final String address;
    private final Date validDateFrom;
    private final Date validDateTo;

    @Override
    public void validate() {
        if(!StringUtils.hasLength(this.getId())) {
            throw new ArgumentTenantException("Id无效");
        }
    }

    public UpdateCredentialCommand(String id,String headPhoto,
                                   String frontPhoto, String reversePhoto,
                                   String address,Date validDateFrom,Date validDateTo) {
        this.id = id;
        this.headPhoto = headPhoto;
        this.frontPhoto = frontPhoto;
        this.reversePhoto = reversePhoto;
        this.address = address;
        this.validDateFrom = validDateFrom;
        this.validDateTo = validDateTo;
    }

    public static UpdateCredentialCommand create(
            String id,
            String headPhoto,
            String frontPhoto,
            String reversePhoto,
            String address,
            Date validDateFrom,
            Date validDateTo) {
        return new UpdateCredentialCommand(id,headPhoto,frontPhoto, reversePhoto,address,validDateFrom,validDateTo);
    }
}
