package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import lombok.Getter;
import org.springframework.util.StringUtils;

@Getter
public class SyncWechatLabelCommand extends CommandAbstract {
    private final String openId;
    private final String nicky;
    private final String id;

    public SyncWechatLabelCommand(String id, String openId, String nicky) {
        this.openId = openId;
        this.nicky = nicky;
        this.id = id;
    }

    public static SyncWechatLabelCommand create(String id, String openId, String nicky) {
        return new SyncWechatLabelCommand(id, openId,nicky);
    }

    @Override
    public void validate() {
        if (!StringUtils.hasLength(this.getId())) {
            throw new ArgumentTenantException("TenantUserId参数无效");
        }
    }
}
