package com.bcxin.tenant.domain.services.commands.tenantUsers;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import com.bcxin.Infrastructures.commands.CommandAbstract;
import com.bcxin.Infrastructures.exceptions.ArgumentTenantException;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.PlatformUpdateUserBasicRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

@Getter
public class PlatformUpdateUserBasicCommand extends CommandAbstract {

    //当前登录的用户id
    private final String tenantUserId;

    //当前登录的职员id
    private final String employeeId;

    //被操作的用户id
    private final String operateUserId;

    //被操作的新姓名
    private final String name;

    //被操作的新手机号
    private final String telephone;

    //操作原因
    private final String operateReason;

    //IP地址
    private final String ipAddress;

    public PlatformUpdateUserBasicCommand(String tenantUserId, String employeeId, String operateUserId, String name,
                                          String telephone, String operateReason, String ipAddress) {
        this.tenantUserId = tenantUserId;
        this.employeeId = employeeId;
        this.operateUserId = operateUserId;
        this.name = name;
        this.telephone = telephone;
        this.operateReason = operateReason;
        this.ipAddress = ipAddress;
    }

    public static PlatformUpdateUserBasicCommand create(PlatformUpdateUserBasicRequest request) {
        return new PlatformUpdateUserBasicCommand(request.getTenantUserId(), request.getEmployeeId(), request.getOperateUserId(),
                request.getName(), request.getTelephone(), request.getOperateReason(), request.getIpAddress());
    }

    public void validate() {
        if (StringUtils.isBlank(this.getTenantUserId())) {
            throw new ArgumentTenantException("当前登录的用户id不能为空");
        }
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        if (!userModel.getId().equals(this.getTenantUserId())) {
            throw new ArgumentTenantException("当前登录的用户id和所传参数不一致");
        }
        if (StringUtils.isBlank(this.getEmployeeId())) {
            throw new ArgumentTenantException("当前登录的职员id不能为空");
        }

        if (StringUtils.isBlank(this.getOperateUserId())) {
            throw new ArgumentTenantException("被操作的用户id不能为空");
        }

        if (StringUtils.isBlank(this.getName()) && StringUtils.isBlank(this.getTelephone())) {
            throw new ArgumentTenantException("新姓名和新手机号，不能同时为空");
        }
    }
}
