package com.bcxin.tenant.domain.repositories.dtos;
import com.bcxin.tenant.domain.entities.valueTypes.LocationValueType;
import lombok.Data;
import java.util.Date;

@Data
public class OrganizationDto {
    private String id;
    private String code;
    private String name;
    private LocationValueType placeOfRegister;
    private LocationValueType placeOfBusiness;
    private String industryCode;
    private String institutionalCode;
    private String logoPath;
    private Date createdTime;
    private Date lastUpdatedTime;
    private String unifySocialCreditCode;
    private String unifySocialCreditCodeFile;

    /**
     * 系统名称
     */
    private String sysName;
    /**
     * 描述
     */
    private String description;
    /**
     * 经度
     */
    private Double longitude;
    /**
     * 纬度
     */
    private Double latitude;

    /**
     * 坐标信息
     */
    private String lonLatJson;

    public OrganizationDto(String id,String name,String unifySocialCreditCode) {
        this.setId(id);
        this.setName(name);
        this.setUnifySocialCreditCode(unifySocialCreditCode);
    }

    public OrganizationDto(String id, String code, String name,
                           LocationValueType placeOfRegister,
                           LocationValueType placeOfBusiness,
                           String industryCode,String institutionalCode,
                           String logoPath,
                           String sysName,
                           String description,
                           Double longitude,
                           Double latitude,
                           Date createdTime,
                           Date lastUpdatedTime,
                           String unifySocialCreditCode,
                           String unifySocialCreditCodeFile,
                           String lonLatJson) {
        this.setId(id);
        this.setCode(code);
        this.setName(name);
        this.setIndustryCode(industryCode);
        this.setInstitutionalCode(institutionalCode);
        this.setLogoPath(logoPath);
        this.setSysName(sysName);
        this.setDescription(description);
        this.setLongitude(longitude);
        this.setLatitude(latitude);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setPlaceOfBusiness(placeOfBusiness);
        this.setPlaceOfRegister(placeOfRegister);
        this.setUnifySocialCreditCode(unifySocialCreditCode);
        this.setUnifySocialCreditCodeFile(unifySocialCreditCodeFile);
        this.setLonLatJson(lonLatJson);
    }


    /**
     *
     * @param id
     * @param code
     * @param name
     * @param placeOfRegister
     * @param placeOfBusiness
     * @param industryCode
     * @param institutionalCode
     * @param logoPath
     * @param sysName
     * @param description
     * @param longitude
     * @param latitude
     * @param createdTime 在Hibernate中, 我指定的是Timestamp,但是这边却只能使用Date
     * @param lastUpdatedTime 在Hibernate中, 我指定的是Timestamp,但是这边却只能使用Date
     * @return
     */
    public static OrganizationDto create(String id, String code, String name,
                                         LocationValueType placeOfRegister,
                                         LocationValueType placeOfBusiness,
                                         String industryCode,String institutionalCode,
                                         String logoPath,
                                         String sysName,
                                         String description,
                                         Double longitude,
                                         Double latitude,
                                         Date createdTime,
                                         Date lastUpdatedTime,
                                         String unifySocialCreditCode,
                                         String unifySocialCreditCodeFile,
                                         String lonLatJson) {
        OrganizationDto organizationDto = new OrganizationDto(
                id, code, name,
                placeOfRegister, placeOfBusiness, industryCode, institutionalCode,
                logoPath, sysName, description, longitude, latitude,
                createdTime, lastUpdatedTime, unifySocialCreditCode, unifySocialCreditCodeFile,lonLatJson);

        return organizationDto;
    }
}
