package com.bcxin.tenant.domain.repositories;

import com.bcxin.tenant.domain.entities.DepartmentEntity;
import com.bcxin.tenant.domain.entities.ImportDataEntity;
import com.bcxin.tenant.domain.entities.OrganizationEntity;
import com.bcxin.tenant.domain.repositories.composites.BatchImportDepart;
import com.bcxin.tenant.domain.repositories.composites.BatchImportDepartResult;
import com.bcxin.tenant.domain.services.commands.BatchImportEmployeeCommand;
import com.bcxin.tenant.domain.services.commands.BatchLeaveEmployeeExcelCommand;
import com.bcxin.tenant.domain.services.commands.contracts.BatchImportContractCommand;
import com.bcxin.tenant.domain.services.commands.results.BatchImportEmployeeCommandResult;
import com.bcxin.tenant.domain.snapshots.EmployeeImportedResultSnapshot;

import java.util.Collection;

public interface CompositeDataRepository {
    BatchImportDepartResult execute(BatchImportDepart data);

    String execute(OrganizationEntity organization, BatchImportEmployeeCommand command);

    String execute(OrganizationEntity organization, BatchImportContractCommand command);
    String execute(OrganizationEntity organization, BatchLeaveEmployeeExcelCommand command);
}
