package com.bcxin.tenant.domain.readers.dtos;

import cn.hutool.core.util.StrUtil;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

@Getter
public class DepartDto {
    private final String employeeId;
    private final String departId;
    private String departName;
    private Boolean departLeader;

    private String indexTree;


    public DepartDto(String employeeId,String departId, String departName, Boolean departLeader) {
        this.employeeId = employeeId;
        this.departId = departId;
        if(StrUtil.isNotEmpty(departName)) {
            this.departName = departName.replaceAll("#"+departId,"");
        }else{
            this.departName = departName;
        }
        this.departLeader = departLeader;
    }
    public DepartDto(String employeeId,String departId, String departName) {
        this.employeeId = employeeId;
        this.departId = departId;
        if(StrUtil.isNotEmpty(departName)) {
            this.departName = departName.replaceAll("#"+departId,"");
        }else{
            this.departName = departName;
        }
    }


    public DepartDto(String employeeId,String departId, String departName,String indexTree) {
        this.employeeId = employeeId;
        this.departId = departId;
        this.indexTree = indexTree;
        if(StrUtil.isNotEmpty(departName)) {
            this.departName = departName.replaceAll("#"+departId,"");
        }else{
            this.departName = departName;
        }
    }

    public void resetDepartName(String departName){
        this.departName = departName;
    }

}