package com.bcxin.tenant.domain.events.handlers;

import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.events.handlers.DomainEventHandlerAbstract;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.events.DepartmentCreatedEvent;
import com.bcxin.tenant.domain.services.TenantEventService;
import com.bcxin.tenant.domain.services.commands.CreateTenantEventCommand;
import org.springframework.stereotype.Component;

@Component
public class DepartmentCreatedEvent_Handler extends DomainEventHandlerAbstract<DepartmentCreatedEvent> {
    private final TenantEventService eventService;
    private final JsonProvider jsonProvider;

    public DepartmentCreatedEvent_Handler(TenantEventService eventService, JsonProvider jsonProvider) {
        this.eventService = eventService;
        this.jsonProvider = jsonProvider;
    }

    @Override
    protected void execute(DepartmentCreatedEvent event) {
        this.eventService.create(CreateTenantEventCommand.create(EventAction.DepartmentCreated, event.getData().getId(), event.getData().getName()));
    }
}
