package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.*;
import java.util.Date;

/**
 * description：异常人员表
 * author：linchunpeng
 * date：2025/7/21
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "tenant_abnormal_personnel")
@Entity
@Data
public class TenantAbnormalPersonnelEntity extends EntityAbstract implements IAggregate {

    /**
     * 主键
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 姓名
     */
    @Column(name = "real_name")
    private String realName;

    /**
     * 性别
     */
    @Column(name = "sex")
    private String sex;

    /**
     * 身份证号码
     */
    @Column(name = "id_card_num")
    private String idCardNum;

    /**
     * 联系电话
     */
    @Column(name = "mobile")
    private String mobile;

    /**
     * 异常原因
     */
    @Column(name = "abnormal_reason")
    private String abnormalReason;

    /**
     * 数据来源
     */
    @Column(name = "data_source")
    private String dataSource;

    /**
     * 限制类型：1仅提醒，2限制入职
     */
    @Column(name = "restricted_type")
    private Integer restrictedType;

    /**
     * 限制区域编码
     */
    @Column(name = "restricted_region_code")
    private String restrictedRegionCode;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

}
