package com.bcxin.tenant.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 配置表
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "sys_config")
@Entity
public class ConfigEntity extends EntityAbstract implements IAggregate {

    /**
     * 参数主键
     */
    @Id
    @Column(name = "config_id")
    private Integer configId;

    /**
     * 是否可用
     */
    @Column(name = "active")
    private String active="1";
    /**
     * 参数名称
     */
    @Column(name = "config_name",nullable = false, length = 100)
    private String configName;
    /**
     * 参数键名
     */
    @Column(name = "config_key",length = 100)
    private String configKey;
    /**
     * 参数键值
     */
    @Column(name = "config_value",length = 500)
    private String configValue;
    /**
     * 备注
     */
    @Column(name = "remark",length = 500)
    private String remark;

}






