package com.bcxin.tenant.domain.entities;

import cn.hutool.core.util.StrUtil;
import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

@Table(name = "vw_company_credential")
@Entity
@Data
public class CompanyCredentialViewEntity extends EntityAbstract implements IAggregate {

    //组织id
    @Id
    @Column(name = "domainid")
    private String domainId;

    /**
     * 公司名称
     */
    @Column(name = "comname")
    private String comName;

    /**
     * 法人
     */
    @Column(name = "legalperson")
    private String legalPerson;

    /**
     * 办公电话
     */
    @Column(name = "tel")
    private String tel;

    /**
     * 注册资金（万元）
     */
    @Column(name = "registeredmoney")
    private String registeredMoney;
    /**
     * 许可证号
     */
    @Column(name = "cerno")
    private String cerNo;
    /**
     * 注册地址
     */
    @Column(name = "address")
    private String address;
    /**
     * 办公地址
     */
    @Column(name = "location")
    private String location;

    /**
     * 发证日期
     */
    @Column(name = "cerdate")
    private Date cerDate;

    /**
     * 服务范围
     */
    @Column(name = "securityscopetype")
    private String securityScopeType;


}
