package com.bcxin.rbac.domain.rm;

import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 授权模块组信息
 * 用于管理已经授权给公司的列表
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "rbac_grant_modules")
@Entity
public class GrantModuleEntity extends MetaEntityAbstract implements IAggregate {
    @Id
    private String id;

    @Column(name = "ref_subject_group_id", length = 200, nullable = false)
    private String refSubjectGroupId;

    @ManyToOne
    @JoinColumn(name = "module_id", referencedColumnName = "id")
    private ModuleEntity module;

    protected GrantModuleEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static GrantModuleEntity create(String refSubjectGroupId, ModuleEntity module) {
        GrantModuleEntity grantModule = new GrantModuleEntity();
        grantModule.setModule(module);
        grantModule.setRefSubjectGroupId(refSubjectGroupId);

        return grantModule;
    }
}
