package com.bcxin.rbac.domain.dtos;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;

@Getter
public class UserDetailDto {
    private final String id;
    private final String name;
    private final String referencedId;
    private final Collection<RoleDetailDto> roleDetails = new ArrayList<>();

    public UserDetailDto(String id, String name, String referencedId) {
        this.id = id;
        this.name = name;
        this.referencedId = referencedId;
    }

    public void assignRoleDetail(RoleDetailDto detailDto) {
        this.getRoleDetails().add(detailDto);
    }

    public static UserDetailDto create(String id, String name, String referencedId) {
        return new UserDetailDto(id,name,referencedId);
    }
}
