package com.bcxin.rbac.domain.services.commands.resources;

import com.bcxin.Infrastructures.commands.CommandAbstract;
import lombok.Getter;

@Getter
public class CreateResourceCommand extends CommandAbstract {
    private final String categoryId;
    private final String code;
    private final String name;
    private final String data;
    private final String dataType;
    private final String parentId;

    public CreateResourceCommand(String categoryId, String code,
                                 String name, String data, String dataType,String parentId) {
        this.categoryId = categoryId;
        this.code = code;
        this.name = name;
        this.data = data;
        this.dataType = dataType;
        this.parentId = parentId;
    }

    public static CreateResourceCommand create(String categoryId, String code,
                                               String name, String data, String dataType,String parentId) {
        return new CreateResourceCommand(categoryId, code, name, data, dataType,parentId);
    }
}
