package com.bcxin.rbac.domain.rm;
import com.bcxin.Infrastructures.entities.IAggregate;
import com.bcxin.Infrastructures.enums.TrueFalseStatus;
import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

/**
 * 抽象为模块
 * 用于管理比如: 应用
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "rabc_modules")
@Entity
public class ModuleEntity extends MetaEntityAbstract implements IAggregate {
    @Id
    private String id;
    @Column(name = "name", length = 200, nullable = false)
    private String name;
    @Column(name = "online", nullable = false)
    private TrueFalseStatus online;

    @OneToMany
    private Collection<GroupEntity> groups;

    protected ModuleEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static ModuleEntity create(String name, boolean online) {
        ModuleEntity module = new ModuleEntity();
        module.setId(UUIDUtil.getShortUuid());
        module.setName(name);
        module.setOnline(online ? TrueFalseStatus.True : TrueFalseStatus.False);

        return module;
    }
}
