package com.bcxin.rbac.domain.rm;

import com.bcxin.Infrastructures.utils.UUIDUtil;
import com.bcxin.rbac.domain.entities.MetaEntityAbstract;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collection;

/**
 * 功能组
 * 作为: 用于管理页面功能列表。 比如: V5的表单/视图
 */
@Getter
@Setter(AccessLevel.PROTECTED)
@Table(name = "rbac_groups")
@Entity
public class GroupEntity extends MetaEntityAbstract {
    @Id
    private String id;

    @Column(name = "name", length = 200)
    private String name;

    @OneToMany
    private Collection<FunctionEntity> functions;

    protected GroupEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static GroupEntity create(String name, String metaId) {
        GroupEntity group = new GroupEntity();
        group.setId(UUIDUtil.getShortUuid());
        group.setMetaId(metaId);
        group.setName(name);

        return group;
    }
}
