package com.bcxin.rbac.domain.events;

import com.bcxin.Infrastructures.events.DomainEventAbstract;
import lombok.Getter;

@Getter
public class EnsureSubjectEvent extends DomainEventAbstract<String> {
    private final String referencedId;
    private final String name;

    public EnsureSubjectEvent(String referencedId, String name) {
        super(referencedId);
        this.referencedId = referencedId;
        this.name = name;
    }

    public static EnsureSubjectEvent create(String referencedId, String name) {
        return new EnsureSubjectEvent(referencedId, name);
    }
}
