package com.bcxin.rbac.domain.entities;

import com.bcxin.Infrastructures.entities.EntityAbstract;
import com.bcxin.Infrastructures.entities.OpEntityAbstract;
import lombok.AccessLevel;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.sql.Timestamp;

@Getter
@Setter(AccessLevel.PROTECTED)
@MappedSuperclass
public class MetaEntityAbstract extends OpEntityAbstract {
    @Column(name = "meta_id", length = 200)
    private String metaId;

    @Column(name = "meta_config", length = 3000)
    private String metaConfig;

    @Column(name = "meta_data", length = 500)
    private String metaData;

    @Column(name = "created_time", nullable = false)
    private Timestamp createdTime;

    /**
     * 扩展字段
     */
    @Column(name = "extend_field", length = 300)
    private String extendField;

    public void changeMeta(String metaId, String metaConfig, String metaData) {
        this.setMetaId(metaId);
        this.setMetaConfig(metaConfig);
        this.setMetaData(metaData);
    }

    public void changeExtend(String extendField) {
        this.setExtendField(extendField);
    }
}
