package com.bcxin.rbac.domain.dtos.custom;

import com.bcxin.Infrastructures.enums.OccupationType;
import com.bcxin.rbac.domain.dtos.CriteriaAbstract;
import lombok.Data;

@Data
public class RbacUserSearchDto extends CriteriaAbstract {

    private String organizationId;
    private Long roleId;
    private String keyWord;
    private String departId;
    private OccupationType occupationType;

    public RbacUserSearchDto(int pageIndex, int pageSize, String organizationId, Long roleId, String keyWord, String departId, OccupationType occupationType) {
        super.changePage(pageIndex, pageSize);
        this.organizationId = organizationId;
        this.roleId = roleId;
        this.keyWord = keyWord;
        this.departId = departId;
        this.occupationType = occupationType;
    }

    public int getSkip() {
        int index = this.getPageIndex() - 1;
        if (index < 0) {
            index = 0;
        }

        return this.getPageSize() * index;
    }
}
