package com.bcxin.rbac.domain.dtos;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;

@Getter
public class CategoryTreeDto {
    private final String id;
    private final String name;
    private final String data;
    private final Collection<ResourceDto> resources= new ArrayList<>();

    public CategoryTreeDto(String id, String name, String data) {
        this.id = id;
        this.name = name;
        this.data = data;
    }

    public void assignResources(Collection<ResourceDto> resourceDtos) {
        this.getResources().addAll(resourceDtos);
    }
}
