package com.bcxin.rbac.domain;

import com.bcxin.Infrastructures.Pageable;
import com.bcxin.rbac.domain.dtos.custom.*;

import java.util.List;

public interface RbacCustomDbReader {

    /**
     * description：查询企业自定义角色列表
     * author：linchunpeng
     * date：2024/2/1
     */
    List<RbacCustomRoleDto> findOrgRoleList(String organizationId, String roleName, String employeeId);

    /**
     * description：分页查询用户职员列表
     * author：linchunpeng
     * date：2024/2/3
     */
    Pageable<RbacUserDto> getRbacUserDtoList(RbacUserSearchDto searchDto);

    /**
     * description：查询企业授权的app列表
     * author：linchunpeng
     * date：2024/2/3
     */
    List<RbacPermitAppDto> findOrgAppList(String organizationId);

    /**
     * description：查询应用的操作项列表
     * author：linchunpeng
     * date：2024/2/3
     */
    List<RbacPermitOptionDto> findAppOptionList(Long appId);

    /**
     * description：通过组织id、姓名列表，查询职员
     * author：linchunpeng
     * date：2024/2/6
     */
    List<RbacUserDto> getRbacUserDtoList(String organizationId, List<String> names);
}
