package com.bcxin.dbfilescanner.dtos;

import java.util.Collection;

public class SecurityManPictureDto {
    private final String id;
    private final Collection<String> paths;

    private boolean isExists = true;
    private boolean isFinishedChecked = false;


    private SecurityManPictureDto(String id, Collection<String> paths) {
        this.id = id;
        this.paths = paths;
    }

    public String getId() {
        return id;
    }

    public Collection<String> getPaths() {
        return paths;
    }

    public boolean isExists() {
        return isExists;
    }

    /**
     * 完成核对
     * @return
     */
    public boolean isFinishedChecked() {
        return isFinishedChecked;
    }

    public static SecurityManPictureDto create(String id, Collection<String> paths) {
        return new SecurityManPictureDto(id, paths);
    }

    public static SecurityManPictureDto createError(String id) {
        SecurityManPictureDto pictureDto = new SecurityManPictureDto(id, null);
        pictureDto.makeAsNotExists();

        return pictureDto;
    }

    public void makeAsNotExists() {
        this.isExists = false;
        this.isFinishedChecked=true;
    }

    public void makeWellDone() {
        this.isExists = true;
        this.isFinishedChecked = true;
    }
}
