package com.bcxin.autodownloadupload.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.autodownloadupload.configs.PushConfig;
import com.bcxin.autodownloadupload.dao.mapper.PushRecordUploadLogMapper;
import com.bcxin.autodownloadupload.entity.PushRecordUploadLog;
import com.bcxin.autodownloadupload.service.PushRecordUploadLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * description: 推送文件上传确认日志表service
 * author: linchunpeng
 * date:  2023-04-19 14:08
 */
@Slf4j
@Service
public class PushRecordUploadLogServiceImpl extends ServiceImpl<PushRecordUploadLogMapper, PushRecordUploadLog> implements PushRecordUploadLogService {

    @Autowired
    private PushConfig pushConfig;


    /**
     * description: 新增日志
     * author: linchunpeng
     * date:  2023-04-21 10:27
     */
    @Override
    public void createLog(String requestId, Long pushRecordId, String fileName, String fileUrl, String visitFileUrl, boolean visitResult) {
        PushRecordUploadLog  pushRecordUploadLog = new PushRecordUploadLog();
        pushRecordUploadLog.setRequestId(requestId);
        pushRecordUploadLog.setPushRecordId(pushRecordId);
        pushRecordUploadLog.setFileName(fileName);
        pushRecordUploadLog.setFileUrl(fileUrl);
        pushRecordUploadLog.setVisitFileUrl(visitFileUrl);
        pushRecordUploadLog.setVisitResult(visitResult);
        pushRecordUploadLog.setCreateTime(new Date());
        this.save(pushRecordUploadLog);
    }


}
