package com.bcxin.autodownloadupload.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.autodownloadupload.dao.mapper.PushRecordMapper;
import com.bcxin.autodownloadupload.entity.PushRecord;
import com.bcxin.autodownloadupload.service.PushRecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * description: 推送记录表service
 * author: linchunpeng
 * date:  2023-04-19 14:08
 */
@Slf4j
@Service
public class PushRecordServiceImpl extends ServiceImpl<PushRecordMapper, PushRecord> implements PushRecordService {


    /**
     * description: 新增推送记录
     * author: linchunpeng
     * date:  2023-04-21 10:27
     */
    @Override
    public PushRecord createRecord(String requestId, String  zipPath, String  unzipPath, String unzipResult) {
        PushRecord record = new PushRecord();
        record.setRequestId(requestId);
        record.setZipPath(zipPath);
        record.setUnzipResult(unzipResult);
        record.setUnzipPath(unzipPath);
        record.setCreateTime(new Date());
        this.save(record);
        return record;
    }

    /**
     * description: 根据requestId查询推送记录
     * author: linchunpeng
     * date:  2023-04-25 9:43
     */
    @Override
    public PushRecord getByRequestId(String requestId) {
        QueryWrapper<PushRecord> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("request_id", requestId);

        List<PushRecord> list = this.list(queryWrapper);
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        return list.get(list.size()-1);
    }

}
