package com.bcxin.autodownloadupload.scheduling;

import com.bcxin.autodownloadupload.configs.PullConfig;
import com.bcxin.autodownloadupload.service.PullDataService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * description: 定时拉取数据调度任务
 * author: linchunpeng
 * date:  2023-04-17 16:02
 */
@Slf4j
@Component
public class PullDataTask {

    @Autowired
    private PullDataService pullDataService;

    @Autowired
    private PullConfig pullConfig;

    /**
     * description: 定时拉取数据调度任务
     * author: linchunpeng
     * date:  2023-04-17 16:03
     */
    @Scheduled(cron = "${pull-config.scheduled.cron}")
    public void pullDataTask() {
        log.info("===================================定时拉取数据调度任务===================================");
        pullDataService.pullData(pullConfig.getChangeLogsRequestDto(), 0);
        log.info("===================================任务结束===================================");
    }

}
