package com.bcxin.backend.domain.enums;

public enum SxCertDn {
    /*
     * 印章参数 sealId:印章id
     * appId:应用id
     * appkey:应用密钥
     * secretKsy印章索引
     * certDN:公钥证书DN项
     */
    TEST610000("测试参数", "O=山东同智伟业软件股份有限公司,CN=ESM_Sign,C=CN", "f9a4d5427d222602017d227e677f0007", "b54ca7b93e7b4a5e8ddd3b6c417064b8", "05294f988305484e9fa425ddc853fa1e", "", ""),
    PROD610000("生产参数", "", "ff80808184e584570184eb6e3c590002", "a93ae6e21a1a4e579df035aed92d9c0d", "61010052ae8cbc47e547b5a002e6e0443640e6", "", "279"),
    C610100("西安市", "", "ff80808191bb38550192981e8d010048", "52ae8cbc47e547b5a002e6e0443640e6", "", "", "971"),
    C610200("铜川市", "", "", "", "", "", ""),
    C610300("宝鸡市", "", "", "", "", "", ""),
    C610400("咸阳市", "", "", "", "", "", ""),
    C610403("杨凌示范区", "", "", "", "", "", ""),
    C610500("渭南市", "", "", "", "", "", ""),
    C610600("延安市", "", "", "", "", "", ""),
    C610700("汉中市", "", "ff80808191bb38550192981e8d010048", "5cb46bd007a24ab4b80fbeb78c2d4b34", "", "", "329"),
    C610800("榆林市", "", "", "", "", "", ""),
    C610900("安康市", "", "", "", "", "", ""),
    C611000("商洛市", "", "", "", "", "", "");
    private final String areaName;
    private final String certDN;
    private final String appId;
    private final String sealId;
    private final String certId;
    private final String appKey;
    private final String secretKey;

    SxCertDn(String areaName, String certDN, String appId, String sealId, String certId, String appKey, String secretKey) {
        this.areaName = areaName;
        this.certDN = certDN;
        this.appId = appId;
        this.sealId = sealId;
        this.certId = certId;
        this.appKey = appKey;
        this.secretKey = secretKey;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getCertDN() {
        return this.certDN;
    }

    public String getAppId() {
        return appId;
    }

    public String getSealId() {
        return sealId;
    }

    public String getCertId() {
        return certId;
    }

    public String getAppKey() {
        return appKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public static SxCertDn getByAreaName(String areaName) {
        for (SxCertDn sxCertDn : SxCertDn.values()) {
            if (areaName.contains(sxCertDn.getAreaName())) {
                return sxCertDn;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(SxCertDn.getByAreaName("西安市公安局"));
    }
}
