package com.bcxin.tenant.open.jdks.responses.exports;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.jdks.responses.PoliceIncidentOverviewResponse;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "PoliceIncidentSsoOverviewExportResponse",title = "PoliceIncidentSsoOverviewExportResponse Sos报警列表")
@Getter
@ColumnWidth(20)
public class PoliceIncidentSsoOverviewExportResponse extends ResponseAbstract {

    @ExcelProperty("操作时间")
    @Schema(name = "createdTime", title = "操作时间")
    private final String createdTime;

    @ExcelProperty("姓名")
    @Schema(name = "tenantUserName", title = "姓名")
    private final String tenantUserName;

    @ExcelProperty("身份证号")
    @Schema(name = "idNumber", title = "身份证号")
    private final String idNumber;

    @ColumnWidth(50)
    @ExcelProperty("公司名称")
    @Schema(name = "organizationName", title = "公司名称")
    private final String organizationName;

    @ColumnWidth(50)
    @ExcelProperty("驻勤点名称")
    @Schema(name = "securityStationName", title = "驻勤点名称")
    private final String securityStationName;

    @ColumnWidth(70)
    @ExcelProperty("驻勤点地址")
    @Schema(name = "securityStationAddress", title = "驻勤点地址")
    private final String securityStationAddress;

    @ColumnWidth(50)
    @ExcelProperty("监管机构名称")
    @Schema(name = "superviseDepartName", title = "监管机构名称")
    private final String superviseDepartName;

    public PoliceIncidentSsoOverviewExportResponse(PoliceIncidentOverviewResponse data) {
        this.createdTime = data.getCreatedTime();
        this.tenantUserName = data.getTenantUserName();
        this.idNumber = data.getIdNumber();
        this.organizationName = data.getOrganizationName();
        this.securityStationName = data.getSecurityStationName();
        this.securityStationAddress = data.getSecurityStationAddress();
        this.superviseDepartName = data.getSuperviseDepartName();
    }


    public static PoliceIncidentSsoOverviewExportResponse create(
            PoliceIncidentOverviewResponse data) {
        return new PoliceIncidentSsoOverviewExportResponse(data);
    }
}
