package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.text.SimpleDateFormat;
import java.util.Date;

@Schema(name = "SecurityStationRailMessageOverviewResponse",title = "SecurityStationRailMessageOverviewResponse 电子围栏告警信息")
@Getter
@ColumnWidth(20)
public class SecurityStationRailMessageOverviewResponse extends ResponseAbstract {
    @ExcelIgnore
    @Schema(name = "id", title = "id")
    private String id;

    @ExcelProperty("告警时间")
    @Schema(name = "eventDate", title = "告警时间")
    private final String eventDate;

    @ExcelProperty("告警类型")
    @Schema(name = "railRuleType", title = "告警类型")
    private final String railRuleTypeText;

    @ExcelProperty("围栏名称")
    @Schema(name = "stationRailName", title = "围栏名称")
    private final String stationRailName;

    @ExcelProperty("姓名")
    @Schema(name = "employeeName", title = "姓名")
    private final String employeeName;

    @ExcelProperty("身份证号")
    @Schema(name = "employeeIdCardNo", title = "身份证号")
    private final String employeeIdCardNo;

    @ColumnWidth(50)
    @ExcelProperty("公司名称")
    @Schema(name = "companyName", title = "公司名称")
    private final String companyName;

    @ColumnWidth(50)
    @ExcelProperty("驻勤点名称")
    @Schema(name = "rail_reference_name", title = "驻勤点名称")
    private final String rail_reference_name;

    @ColumnWidth(70)
    @ExcelProperty("驻勤点地址")
    @Schema(name = "rail_reference_address", title = "驻勤点地址")
    private final String rail_reference_address;

    @ColumnWidth(50)
    @ExcelProperty("驻勤点监管机构")
    @Schema(name = "rail_reference_supervise_depart_name", title = "驻勤点监管机构")
    private final String rail_reference_supervise_depart_name;

    @ExcelIgnore
    private final String projectId;
    @ExcelIgnore
    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    public SecurityStationRailMessageOverviewResponse(
            Long pkId,
            Date eventDate, RailRuleType railRuleType, String stationRailName,
            String employeeName, String employeeIdCardNo, String companyName,
            String rail_reference_name, String rail_reference_address,
            String rail_reference_supervise_depart_name,
            String projectId, String projectName) {
        this.projectId = projectId;
        this.projectName = projectName;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.eventDate = dateFormat.format(eventDate);
        switch (railRuleType) {
            case Exit -> this.railRuleTypeText = "离开告警";
            case Enter -> this.railRuleTypeText = "进入告警";
            default -> throw new BadTenantException(String.format("非预期告警类型:%s", railRuleType));
        }
        this.stationRailName = stationRailName;
        this.employeeName = employeeName;
        this.employeeIdCardNo = employeeIdCardNo;
        this.companyName = companyName;
        this.rail_reference_name = rail_reference_name;
        this.rail_reference_address = rail_reference_address;
        this.id = String.valueOf(pkId);
        this.rail_reference_supervise_depart_name = rail_reference_supervise_depart_name;
    }


    public static SecurityStationRailMessageOverviewResponse create(Long pkId,
                                                                     Date eventDate, RailRuleType railRuleType, String stationRailName,
                                                                    String employeeName, String employeeIdCardNo, String companyName,
                                                                    String rail_reference_name, String rail_reference_address,
                                                                    String rail_reference_supervise_depart_name,
                                                                    String projectId,String projectName) {
        return new SecurityStationRailMessageOverviewResponse(pkId, eventDate, railRuleType, stationRailName, employeeName, employeeIdCardNo,
                companyName, rail_reference_name, rail_reference_address, rail_reference_supervise_depart_name,
                projectId, projectName);
    }
}
