package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.constants.BusinessConstants;
import com.bcxin.tenant.open.jdks.requests.SecurityStationReaderRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Collection;
import java.util.Set;

@Schema(name = "SecurityStationOverviewReaderResponse",title = "SecurityStationOverviewReaderResponse 驻勤列表基本信息")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SecurityStationOverviewReaderResponse extends ResponseAbstract {
    @Schema(name = "id", title = "驻勤点Id")
    private final String id;
    @Schema(name = "name", title = "驻勤点名称")
    private final String name;

    @Schema(name = "organizationId", title = "企业Id")
    private final String organizationId;
    @Schema(name = "companyName", title = "企业名称")
    private final String companyName;
    @Schema(name = "latitude", title = "驻勤点所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "驻勤点所在x轴坐标")
    private final Double longitude;
    @Schema(name = "address", title = "驻勤地址")
    private final String address;
    @Schema(name = "stationTypes", title = "驻勤点类型; 返回驻勤编码; 前端根据/station-types返回的API数据进行渲染")
    private final Collection<String> stationTypes;

    @Schema(name = "superviseDepartId", title = "所在驻勤的监管归属信息")
    private final String superviseDepartId;

    private final Set<String> followedDeviceNos;

    @Schema(name = "isFollowed", title = "是否关注")
    private final Boolean followed;

    @Schema(name = "superviseDepartId", title = "负责人")
    private final String principalName;

    @Schema(name = "projectId", title = "临保项目Id")
    private final String projectId;

    @Schema(name = "projectName", title = "临保项目")
    private final String projectName;

    @Schema(name = "superviseDepartId", title = "驻勤人数")
    private final Integer countOfSecurityMan;

    @Schema(name = "rts", title = "资源类型: Security=驻勤点;Population=社区警务;Proprietor=内保单位的东西（暂无）;ProprietorManaged=内保单位管理的驻勤点")
    private final Set<String> rts;

    public SecurityStationOverviewReaderResponse(
            SecurityStationReaderRequest.SearchModel mode,
            String id, String name,
            String organizationId, String companyName, Double latitude,
            Double longitude, String address,
            Collection<String> stationTypes, String superviseDepartId,
            Set<String> followedDeviceNos, boolean followed, String principalName, Integer countOfSecurityMan,
            Set<String> resourceTypes,
            String projectId, String projectName) {
        this.id = id;
        this.projectId = projectId;
        this.projectName = projectName;

        if(BusinessConstants.INVALID_LON_LAT==latitude || BusinessConstants.INVALID_LON_LAT==longitude) {
            this.latitude = null;
            this.longitude = null;
        }
        else {
            this.latitude = latitude;
            this.longitude = longitude;
        }

        this.stationTypes = stationTypes;
        this.rts = resourceTypes;

        if (mode != SecurityStationReaderRequest.SearchModel.SecurityResource) {
            this.name = name;
            this.companyName = companyName;
            this.organizationId = organizationId;
            this.countOfSecurityMan = countOfSecurityMan;

            this.address = address;

            this.superviseDepartId = superviseDepartId;
            this.followedDeviceNos = followedDeviceNos;
            this.followed = followed;
            this.principalName = principalName;
        } else {
            this.name = null;
            this.companyName = null;
            this.address = null;
            this.superviseDepartId = null;
            this.followedDeviceNos = null;
            this.followed = null;
            this.principalName = null;
            this.organizationId = null;
            this.countOfSecurityMan = null;
        }
    }

    public static SecurityStationOverviewReaderResponse create(
            SecurityStationReaderRequest.SearchModel mode,
            String id, String name, String organizationId,
            String companyName, Double latitude,
            Double longitude, String address,
            Collection<String> stationTypes, String superviseDepartId,
            Set<String> followedDeviceNos,
            boolean followed,String principalName,Integer countOfSecurityMan,
            Set<String> resourceTypes,
            String projectId, String projectName) {
        return new SecurityStationOverviewReaderResponse(
                mode,
                id, name, organizationId, companyName, latitude, longitude, address, stationTypes,
                superviseDepartId, followedDeviceNos, followed, principalName,
                countOfSecurityMan,resourceTypes, projectId, projectName);
    }
}
