package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.utils.BusinessUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.StationTypeMapValueType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Set;

@Schema(name = "SecurityStationDetailResponse",title = "SecurityStationDetailResponse 驻勤点详情信息")
@Getter
public class SecurityStationDetailResponse extends ResponseAbstract {
    @Schema(name = "id", title = "驻勤点id")
    private final String id;
    @Schema(name = "name", title = "驻勤点名称")
    private final String name;

    @Schema(name = "keyword", title = "关键字搜索词")
    private final String keyword;
    @Schema(name = "siteState", title = "驻勤状态")
    private final String siteState;
    @Schema(name = "stationTypes", title = "驻勤类型")
    private final Collection<StationTypeMapValueType> stationTypes;

    @Schema(name = "organizationId", title = "企业Id")
    private final String organizationId;
    @Schema(name = "companyName", title = "企业名称")
    private final String companyName;
    @Schema(name = "principalId", title = "负责人Id")
    private final String principalId;
    @Schema(name = "principalName", title = "负责人姓名")
    private final String principalName;
    @Schema(name = "principalContact", title = "负责人联系方式")
    private final String principalContact;
    @Schema(name = "serviceScope", title = "服务对象名称")
    private final String serviceScope;
    @Schema(name = "address", title = "驻勤点地址")
    private final String address;
    @Schema(name = "latitude", title = "驻勤点所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "驻勤点所在x轴坐标")
    private final Double longitude;
    @Schema(name = "countOfSecurityMan", title = "保安员人数")
    private final Integer countOfSecurityMan;

    @Schema(name = "countOfCommunityUser", title = "社区警务人员")
    private final Integer countOfCommunityUser;

    @Schema(name = "superviseDepartId", title = "所在驻勤的监管归属信息")
    private final String superviseDepartId;

    @Schema(name = "superviseDepartName", title = "所在驻勤的监管归属名称")
    private final String superviseDepartName;

    private final Set<String> followedDeviceNos;

    @Schema(name = "isFollowed", title = "是否关注")
    private final boolean followed;

    @Schema(name = "resourceTypes", title = "资源类型: Security=驻勤点;Population=社区警务;Proprietor=内保单位的东西（暂无）;ProprietorManaged=内保单位管理的驻勤点")
    private final Set<String> resourceTypes;

    @Schema(name = "institutional", title = "所属公司的机构类型")
    private final String institutional;

    @Schema(name = "institutionalName", title = "所属公司的机构类型名称")
    private final String institutionalName;

    @Schema(name = "relativeSuperviseDepartIds", title = "relativeSuperviseDepartIds")
    private final Set<String> relativeSuperviseDepartIds;

    @Schema(name = "proprietorCompanyId", title = "所服务的内保单位Id")
    private final String proprietorCompanyId;

    @Schema(name = "proprietorCompanyName", title = "所服务的内保单位信息")
    private final String proprietorCompanyName;

    @Schema(name = "lastSyncTime", title = "最后同步时间")
    private final Timestamp lastSyncTime;

    @Schema(name = "scopePermissions", title = "调试: 可被查询范围")
    private final Set<String> scopePermissions;

    @Schema(name = "performRange", title = "驻勤点的执行范围")
    private final Double performRange;

    @Schema(name = "projectId", title = "项目Id")
    private final String projectId;

    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    @Schema(name = "hasVideo", title = "是否含有视频监控; 有的话, 跳转到视频监控的页面")
    private final boolean hasVideo;

    public SecurityStationDetailResponse(String id, String name,
                                         String keyword,
                                         String siteState,
                                         Collection<StationTypeMapValueType> stationTypes,
                                         String organizationId, String companyName,
                                         String principalId, String principalName, String principalContact,
                                         String serviceScope, String address,
                                         Double latitude, Double longitude,
                                         Integer countOfSecurityMan,
                                         String superviseDepartId,
                                         String superviseDepartName,
                                         Set<String> followedDeviceNos, boolean followed,
                                         Set<String> resourceTypes,
                                         String institutional,
                                         Integer countOfCommunityUser,
                                         Set<String> relativeSuperviseDepartIds,
                                         String proprietorCompanyId,
                                         String proprietorCompanyName,
                                         Set<String> scopePermissions,
                                         Timestamp lastSyncTime,
                                         Double performRange,
                                         String projectId, String projectName,
                                         Boolean hasVideo) {
        this.id = id;
        this.name = name;
        this.siteState = siteState;
        this.stationTypes = stationTypes;
        this.organizationId = organizationId;
        this.companyName = companyName;
        this.principalId = principalId;
        this.principalName = principalName;
        this.principalContact = principalContact;
        this.serviceScope = serviceScope;
        this.address = address;
        this.latitude = latitude;
        this.longitude = longitude;
        this.countOfSecurityMan = countOfSecurityMan;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.followedDeviceNos = followedDeviceNos;
        this.followed = followed;
        this.keyword = keyword;
        this.resourceTypes = resourceTypes;
        this.institutional = institutional;
        this.countOfCommunityUser = countOfCommunityUser;
        this.relativeSuperviseDepartIds = relativeSuperviseDepartIds;
        this.proprietorCompanyId = proprietorCompanyId;
        this.proprietorCompanyName = proprietorCompanyName;
        this.scopePermissions = scopePermissions;

        this.institutionalName = BusinessUtil.getInstitutionalName(institutional);
        this.lastSyncTime = lastSyncTime;
        this.performRange = performRange;
        this.projectId = projectId;
        this.projectName = projectName;
        this.hasVideo = hasVideo == null ? false : hasVideo.booleanValue();
    }

    public static SecurityStationDetailResponse create(String id,
                                                       String name,
                                                       String keyword,
                                                       String siteState,
                                                       Collection<StationTypeMapValueType> stationTypes,
                                                       String organizationId,
                                                       String companyName,
                                                       String principalId,
                                                       String principalName,
                                                       String principalContact,
                                                       String serviceScope,
                                                       String address,
                                                       Double latitude,
                                                       Double longitude,
                                                       Integer countOfSecurityMan,
                                                       String superviseDepartId,
                                                       String superviseDepartName,
                                                       Set<String> followedDeviceNos,
                                                       boolean followed,
                                                       Set<String> resourceTypes,
                                                       String institutional,
                                                       Integer countOfCommunityUser,
                                                       Set<String> relativeSuperviseDepartIds,
                                                       String proprietorCompanyId,
                                                       String proprietorCompanyName,
                                                       Set<String> scopePermissions,
                                                       Timestamp lastSyncTime,
                                                       Double performRange,
                                                       String projectId, String projectName,
                                                       Boolean hasVideo
    ) {
        return new SecurityStationDetailResponse(id, name, keyword, siteState, stationTypes,
                organizationId, companyName,
                principalId, principalName, principalContact,
                serviceScope, address, latitude, longitude, countOfSecurityMan,
                superviseDepartId, superviseDepartName, followedDeviceNos, followed, resourceTypes, institutional,
                countOfCommunityUser, relativeSuperviseDepartIds, proprietorCompanyId,
                proprietorCompanyName,scopePermissions,
                lastSyncTime,performRange, projectId, projectName,hasVideo);
    }
}
