package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Collection;

@Schema(name = "RoomResponse",title = "RoomResponse 音视频会议房间信息")
@Getter
public class RoomResponse extends ResponseAbstract {
    @Schema(name = "id", title = "房间号")
    private final String id;
    @Schema(name = "roomUsers", title = "房间里的人员信息")
    private final Collection<RoomUserResponse> roomUsers;

    @Schema(name = "activated", title = "房间是否有效;  true的时候保安人员可以加入房间, false则无法加入")
    private final boolean activated;

    public RoomResponse(Long id,boolean activated, Collection<RoomUserResponse> roomUsers) {
        this.id = String.valueOf(id);
        this.roomUsers = roomUsers;
        this.activated = activated;
    }

    public static RoomResponse create(Long id,boolean activated, Collection<RoomUserResponse> roomUsers) {
        return new RoomResponse(id, activated, roomUsers);
    }

    @Schema(name = "RoomUserResponse",title = "RoomUserResponse 房间里面的人员详细信息")
    @Getter
    public static class RoomUserResponse extends ResponseAbstract {
        @Schema(name = "employeeId", title = "职员Id")
        private final String employeeId;
        @Schema(name = "employeeName", title = "职员姓名")
        private final String employeeName;
        @Schema(name = "organizationId", title = "组织Id")
        private final String organizationId;
        @Schema(name = "organizationName", title = "组织名称")
        private final String organizationName;
        @Schema(name = "tencentUserId", title = "音视频号")
        private final String tencentUserId;
        @Schema(name = "securityStationId", title = "驻勤点Id")
        private final String securityStationId;
        @Schema(name = "securityStationName", title = "驻勤名称")
        private final String securityStationName;
        @Schema(name = "superviseDepartId", title = "监管归属")
        private final String superviseDepartId;
        @Schema(name = "sponsor", title = "是否为会议发起人")
        private final boolean isSponsor;

        @Schema(name = "cid", title = "cid")
        private final String cid;



        public RoomUserResponse(String employeeId, String employeeName,
                                String organizationId, String organizationName,
                                String tencentUserId, String securityStationId,
                                String securityStationName, String superviseDepartId,
                                boolean isSponsor,
                                String cid) {
            this.employeeId = employeeId;
            this.employeeName = employeeName;
            this.organizationId = organizationId;
            this.organizationName = organizationName;
            this.tencentUserId = tencentUserId;
            this.securityStationId = securityStationId;
            this.securityStationName = securityStationName;
            this.superviseDepartId = superviseDepartId;
            this.isSponsor = isSponsor;
            this.cid = cid;
        }

        public static RoomUserResponse create(String employeeId, String employeeName,
                                              String organizationId, String organizationName,
                                              String tencentUserId, String securityStationId,
                                              String securityStationName, String superviseDepartId,
                                              boolean isSponsor,String cid) {
            return new RoomUserResponse(employeeId, employeeName, organizationId, organizationName,
                    tencentUserId, securityStationId, securityStationName,
                    superviseDepartId, isSponsor, cid);
        }
    }
}
