package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;

@Getter
public class RollCallEmployeeGroupSearchResponse extends ResponseAbstract {
    private final String rollCallId;

    private final String stationId;
    private final String stationName;
    private final String superviseDepartName;
    private final Collection<String> stationTypes;
    private final String organizationName;
    private final String createdTime;
    private final int countOfMembers;
    private final int countOfSuccess;
    private final int countOfFailed;
    private final String actionEmployeeName;

    public RollCallEmployeeGroupSearchResponse(
            long rollCallId,
            String stationId, String stationName, Collection<String> stationTypes,
            String superviseDepartName, String organizationName, Timestamp createdTime,
            int countOfMembers, int countOfSuccess, int countOfFailed,
            String actionEmployeeName) {
        this.rollCallId = String.valueOf(rollCallId);
        this.stationId = stationId;
        if (StringUtil.isEmpty(stationName)) {
            this.stationName = "";
        } else {
            this.stationName = stationName.replace("\"", "");
        }

        if (StringUtil.isEmpty(superviseDepartName)) {
            this.superviseDepartName = "";
        } else {
            this.superviseDepartName = superviseDepartName.replace("\"", "");
        }

        this.organizationName = organizationName;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.createdTime = dateFormat.format(createdTime);
        this.countOfMembers = countOfMembers;
        this.countOfSuccess = countOfSuccess;
        this.countOfFailed = countOfFailed;
        this.actionEmployeeName = actionEmployeeName;
        this.stationTypes = stationTypes;
    }

    public static RollCallEmployeeGroupSearchResponse create(
            long rollCallId,String stationId,
            String stationName, Collection<String> stationTypes,
                                                             String superviseDepartName, String organizationName, Timestamp createdTime,
                                                             int countOfMembers, int countOfSuccess, int countOfFailed,
                                                             String actionEmployeeName) {
        return new RollCallEmployeeGroupSearchResponse(
                rollCallId,
                stationId, stationName, stationTypes, superviseDepartName,
                organizationName, createdTime, countOfMembers, countOfSuccess, countOfFailed, actionEmployeeName);
    }
}
