package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Collection;
import java.util.HashSet;

@Schema(name = "ProjectTeamResponse",title = "临保项目-团队信息")
@Getter
public class ProjectTeamResponse extends ResponseAbstract {
    @Schema(name = "id", title = "项目Id")
    private final String id;
    @Schema(name = "name", title = "项目组名称")
    private final String name;
    @Schema(name = "organizationId", title = "企业Id")
    private final String organizationId;

    @Schema(name = "projectId", title = "项目组Id")
    private final String projectId;
    @Schema(name = "children", title = "子组信息")
    private final Collection<ProjectTeamResponse> children;

    public ProjectTeamResponse(String id, String name, String organizationId,
                               String projectId) {
        this.id = id;
        this.name = name;
        this.organizationId = organizationId;
        this.projectId = projectId;
        this.children = new HashSet<>();
    }

    public static ProjectTeamResponse create(String id, String name, String organizationId,
                                             String projectId) {
        return new ProjectTeamResponse(id, name, organizationId, projectId);
    }

    public void AddChild(ProjectTeamResponse item) {
        this.children.add(item);
    }
}
