package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import lombok.Getter;

@Getter
public class DispatchDataSourceResponse extends ResponseAbstract {
    private final String id;
    private final String name;

    public DispatchDataSourceResponse(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static DispatchDataSourceResponse create(String id, String name) {
        return new DispatchDataSourceResponse(id, name);
    }

    private static DispatchDataSourceResponse emptyValue = new DispatchDataSourceResponse(null,null);
    public static DispatchDataSourceResponse empty() {
        return emptyValue;
    }
}
