package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;

@Schema(name = "DepartmentlevelHierarchyResponse",title = "DepartmentlevelHierarchyResponse 监管部门层级")
@Getter
public class DepartmentlevelHierarchyResponse extends ResponseAbstract {
    @Schema(name = "code", title = "编码")
    private final String code;
    @Schema(name = "name;", title = "监管机构名称")
    private final String name;

    @JsonIgnore
    @Schema(name = "superior", title = "上级编码")
    private final String superior;

    @JsonIgnore
    @Schema(name = "indexCode", title = "上级编码")
    private final String indexCode;

    @Schema(name = "selectable", title = "针对安保资源, 该选项是否是可以选择进去过滤")
    private final boolean selectable;

    private final Collection<DepartmentlevelHierarchyResponse> children;

    public boolean contain(String code) {
        return this.getCode().equalsIgnoreCase(code) || (this.getChildren() != null && this.getChildren().stream().anyMatch(ii -> ii.contain(code)));
    }

    public DepartmentlevelHierarchyResponse(String code, String name, String superior,String indexCode,
                                            Collection<DepartmentlevelHierarchyResponse> children,
                                            boolean topElement) {
        this.code = code;
        this.name = name;
        this.superior = superior;
        this.indexCode = indexCode;
        if (children == null) {
            this.children = new ArrayList<>();
        } else {
            this.children = children;
        }

        if (((name.contains("总队") && !name.contains("分局")) || name.contains("市局")) && topElement && !name.contains("公交总队")) {
            this.selectable = false;
        } else {
            this.selectable = true;
        }
    }

    public void addAll(Collection<DepartmentlevelHierarchyResponse> data) {
        if (data == null || data.size() == 0) {
            return;
        }

        this.getChildren().addAll(data);
    }


    public static DepartmentlevelHierarchyResponse create(String code, String name, String superior,String indexCode,
                                                          Collection<DepartmentlevelHierarchyResponse> children,
                                                          boolean topElement) {
        return new DepartmentlevelHierarchyResponse( code, name, superior,indexCode, children,topElement);
    }
}
