package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

@Schema(name = "RollCallSearchRequest",description = "点名轮换")
@Data
public class RollCallEmployeeGroupSearchRequest extends SearchRequestAbstract {
    @Schema(name = "rollCallPlanId", title = "点名计划对应的点名数据")
    private Long rollCallPlanId;

    @Schema(name = "stationName", title = "驻勤点名称")
    private String stationName;
    @Schema(name = "superviseDepartIds", title = "辖区信息")
    private Collection<String> superviseDepartIds;
    @Schema(name = "stationTypes", title = "驻勤点类型")
    private Collection<String> stationTypes;
    @Schema(name = "actionEmployeeName", title = "点名发起人")
    private String actionEmployeeName;
    @Schema(name = "beginDate", title = "点名时间")
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date beginDate;
    @Schema(name = "endDate", title = "点名截至时间")
    @JsonFormat(pattern = "yyyy-MM-dd hh:mm:ss")
    private Date endDate;
    @Schema(name = "callTypes", title = "点名轮换的状态：点名/督导; 从点名轮换列表进来的时候; 设置RollCall; 督导则设置: Dispatch")
    private Collection<RollCallType> callTypes;
}
