package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.valueTypes.LonLatValueType;
import com.bcxin.tenant.open.jdks.requests.enums.DispatchableType;
import lombok.Data;

import java.util.Collection;

@Data
public class EmployeeReaderRequest extends RequestAbstract {
    /**
     * 姓名
     */
    private String name;
    /**
     * 身份证信息
     */
    private String idCardNo;
    /**
     * 可调度类型
     */
    private DispatchableType dispatchableType;

    /**
     * 当前坐标
     */
    private LonLatValueType lonLat;
    /**
     * 周边范围多少米
     */
    private double distance;

    /**
     * 驻勤类型
     */
    private Collection<String> stationCodes;
}
