package com.bcxin.tenant.open.jdks.requests;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collection;

@Schema(name = "DispatchLogSearchRequest",title = "DispatchLogSearchRequest 高级筛选条件")
@Data
public class DispatchLogSearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "callerName", title = "调度方")
    private String callerName;
    @Schema(name = "calledCompanyName", title = "被调度方")
    private String calledCompanyName;

    @Schema(name = "dispatchedDateFrom", title = "调度开始时间 yyyy-MM-dd hh:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Timestamp dispatchedDateFrom;

    @Schema(name = "dispatchedDateTo", title = "调度结束时间 yyyy-MM-dd hh:mm:ss")
    @JsonFormat(timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    private Timestamp dispatchedDateTo;

    @Schema(name = "superviseDepartIds", title = "监管机构ID")
    private Collection<String> superviseDepartIds;
    @Schema(name = "projectName", title = "项目名称")
    private String projectName;
}
