package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Schema(name = "CreatePoliceIncidentsRequest",title = "CreatePoliceIncidentsRequest 新增警情上报")
@Data
public class CreatePoliceIncidentsRequest extends RequestAbstract {

    @Schema(name = "category", title = "事件类别")
    private PoliceEventCategory category;

    @Schema(name = "contact", title = "联系电话")
    private String contact;

    @Schema(name = "sceneUrl", title = "现场图片")
    private String sceneUrl;

    @Schema(name = "policeEventLevel", title = "事件级别：Comon 一般，More 较大，Great 重大，Greats 特别重大")
    private PoliceEventLevel policeEventLevel;

    @Schema(name = "policeEventType", title = "事件类型:根据category取得不同的值; 相关的值参考: /json/policeIncident-meta.json; 当category=QT的时候; 取0")
    private int policeEventType;

    @Schema(name = "address", title = "事件地址")
    private String address;

    @Schema(name = "reason", title = "事件起因")
    private String reason;

    @Schema(name = "actionTaken", title = "已采取措施")
    private String actionTaken;

    @Schema(name = "actionTendency", title = "发展趋势")
    private String actionTendency;

    @Schema(name = "latitude", title = "纬度 y")
    private double latitude;

    @Schema(name = "longitude", title = "经度 x")
    private double longitude;

    @Schema(name = "location", title = "报警地址")
    private String location;

    @Schema(name = "description", title = "事件说明")
    private String description;
}
