package com.bcxin.tenant.open.jdks.requests;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;

@Schema(name = "CompanySearchRequest",title = "CompanySearchRequest 搜索企业信息")
@Data
public class CompanySearchRequest extends SearchDeskRequestAbstract {
    @Schema(name = "institutionals", title = "企业类型：0102代表：保安服务公司；0103代表：保安培训单位；0104代表：自行招用保安员单位;内保单位类型等")
    private Collection<String> institutionals;

    @Schema(name = "superviseDepartIds", title = "选中辖区的时候，自动将子集推送给服务端；来实现选中派出所的时候; 默认可以显示分局及派出所数据")
    private Collection<String> superviseDepartIds;

    @Schema(name = "keyword", title = "单位名称; 比如用于搜索内保单位的信息")
    private String keyword;

    @Schema(name = "followed",title = "安保资源: 当searchModel=SecurityResource 的时候有效; 根据是否关注进行过滤(null=全部; false=未关注; true=关注)")
    private Boolean followed;

    @Schema(name = "searchModel", title = "搜索模式: security为常规治安的搜索; keyword比如: 针对目前内保的分页搜索")
    private SearchModel searchModel;

    public static enum SearchModel {
        /**
         * 内保单位的搜索
         */
        Keyword,
        /**
         * 常规比如: 保安公司的搜索
         */
        @Schema(name = "SecurityResource", title = "安保资源;比如根据")
        SecurityResource,
    }
}
