package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.*;
import com.bcxin.tenant.open.infrastructures.models.AgentHeaderOptionValue;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Schema(name = "AttendanceWriterRequest",title = "AttendanceWriterRequest 新增上送")
@Data
public class AttendanceWriterRequest extends RequestAbstract {

    @Schema(name = "recordStatus", title = "状态：SignIn 签到，SignOut 签退")
    private RecordStatus recordStatus;

    @Schema(name = "referenceType", title = "类型：Comon 普通，Station 驻勤点")
    private ReferenceType referenceType;

    @Schema(name = "referenceNumber", title = "referenceType 类型：Comon 为空，Station 传驻勤点Id")
    private String referenceNumber;

    @Schema(name = "note", title = "备注")
    private String note;

    @Schema(name = "address", title = "地址")
    private String address;

    @Schema(name = "latitude", title = "维度 y")
    private double latitude;

    @Schema(name = "longitude", title = "经度 x")
    private double longitude;

    @Schema(name = "headerOption", title = "请求头信息", hidden = true)
    private AgentHeaderOptionValue headerOption;

    @Schema(name = "actionCode", title = "用于提交签到/签退的动作依据")
    private String actionCode;
}
