package com.bcxin.tenant.open.infrastructures.enums;

public enum DispatchDataScopeType {
    Supervised {
        @Override
        public String getTypeName() {
            return "监管";
        }

        @Override
        public int getValue() {
            return 0;
        }
    },

    Proprietor {
        @Override
        public String getTypeName() {
            return "内保单位";
        }

        @Override
        public int getValue() {
            return 1;
        }
    },
    Company {
        @Override
        public String getTypeName() {
            return "集团公司";
        }

        @Override
        public int getValue() {
            return 2;
        }
    },
    EventOrganizer {
        @Override
        public String getTypeName() {
            return "大型活动承办单位";
        }

        @Override
        public int getValue() {
            return 3;
        }
    },
    EventOrganizerManager {
        @Override
        public String getTypeName() {
            return "大型活动承办单位-管理人员";
        }

        @Override
        public int getValue() {
            return 4;
        }
    },
    EventOrganizerLimitedResource {
        @Override
        public String getTypeName() {
            return "大型活动-管理单位限制的岗点信息";
        }

        @Override
        public int getValue() {
            return 5;
        }
    },
    /**
     * 特殊授予的权限
     * 比如: 晋城市公安局与监管层级不一致的问题, 因此, 针对晋城市公安局授权了权限
     */
    AssignedOrgPermissionResources{
        @Override
        public String getTypeName() {
            return "大型活动-特殊授予的权限";
        }

        @Override
        public int getValue() {
            return 6;
        }
    };

    public abstract String getTypeName();

    public abstract int getValue();
}
