package com.bcxin.tenant.open.infrastructures.models;

import lombok.Getter;

import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Instant;

/**
 * 缓存数据
 * @param <T>
 */
@Getter
public class CacheData<T> implements Serializable {
    private final T data;
    private final Timestamp createdTime;
    private final Timestamp expiredTime;

    private final int expiredInSeconds;

    public CacheData(T data, int expiredInSeconds) {
        this.data = data;
        this.createdTime = Timestamp.from(Instant.now());
        this.expiredInSeconds = expiredInSeconds;
        this.expiredTime = Timestamp.from(Instant.now().plusMillis(expiredInSeconds * 1000));
    }

    public boolean IsExpired() {
        Timestamp now = Timestamp.from(Instant.now());

        return now.after(this.getExpiredTime());
    }

    public static <T> CacheData create(T data, int expiredInSeconds) {
        return new CacheData(data, expiredInSeconds);
    }
}
