package com.bcxin.tenant.open.infrastructures.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;

@Getter
public enum RollCallStatus {
    RollCallInit(1 << 0, "点名初始化"),
    RollCallSuccess(1 << 1, "点名成功"),
    RollCallFailed(1 << 2, "点名失败"),
    DispatchInit(1 << 3, "督导初始化"),
    DispatchSuccess(1 << 4, "督导成功"),
    DispatchFailed(1 << 5, "督导失败"),;

    String name;
    int value;
    private RollCallStatus(int value, String name) {
        this.name = name;
        this.value = value;
    }

    public static int calculate(Collection<RollCallStatus> callStatuses) {
        int result = 0;
        if (callStatuses != null && !callStatuses.isEmpty()) {
            for (RollCallStatus rule : callStatuses.stream().distinct().collect(Collectors.toList())) {
                result = result | rule.value;
            }
        }

        return result;
    }

    public static Collection<RollCallStatus> getSelectedRollCallStatuses(int rollCallStatus) {
        Collection<RollCallStatus> result = new HashSet<>();
        for (RollCallStatus status : RollCallStatus.values()) {
            if ((status.value & rollCallStatus) > 0) {
                result.add(status);
            }
        }

        return result;
    }

    public static Collection<RollCallStatus> calculateRollCallStatus(Collection<RollCallStatus> currentStatuses,RollCallStatus newStatus) {
        if (currentStatuses == null) {
            currentStatuses = new ArrayList<>();
        }

        if (newStatus == DispatchFailed || newStatus == DispatchSuccess) {
            currentStatuses = currentStatuses.stream().filter(ii ->
                            ii != DispatchSuccess && ii != DispatchFailed && ii != DispatchInit)
                    .collect(Collectors.toList());
        } else {
            currentStatuses = currentStatuses.stream().filter(ii -> ii != RollCallSuccess && ii != RollCallFailed && ii != RollCallInit)
                    .collect(Collectors.toList());
        }

        currentStatuses.add(newStatus);

        return currentStatuses;
    }
}
