package com.bcxin.tenant.open.infrastructures.constants;

public class KafkaConstants {
    public static final int PARTITION_COUNT = 3;
    public static final String TOPIC_OBPM2_TENANT_EMPLOYEES = "obpm2.binlog-cdc.topic.v2.tenant_employees";

    public static final String TOPIC_OBPM2_EXTERNAL_MEMBERS = "obpm2.binlog-cdc.topic.v2.external_members";
    public static final String TOPIC_OBPM2_TENANT_USERS = "obpm2.binlog-cdc.topic.v2.tenant_users";
    public static final String TOPIC_OBPM2_TENANT_ORGANIZATIONS = "obpm2.binlog-cdc.topic.v2.tenant_organizations";
    public static final String TOPIC_BAIBAODUNFLOW_TLK_COMPANYINFORMATION = "baibaodunflow.binlog-cdc.topic.v2.tlk_companyinformation";
    public static final String TOPIC_BAIBAODUNFLOW_TLK_STATION = "baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_base_info";
    public static final String TOPIC_BAIBAODUNFLOW_TLK_STATION_PERSON = "baibaodunflow.binlog-cdc.topic.v2.tlk_attendance_site_person_info";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_PT_SECURITYMAN = "baibaodunflow.binlog-cdc.topic.v2.tlk_pt_securityman";

    public static final String TOPIC_DISPATCH_TLK_DEVICE = "dispatch.binlog-cdc.topic.v2.tlk_device";

    public static final String TOPIC_DISPATCH_TLK_ORG_PURSE = "dispatch.binlog-cdc.topic.v2.tlk_org_purse";

    public static final String TOPIC_DISPATCH_VGA_ROOMS = "dispatch.binlog-cdc.topic.v2.vga_rooms";

    public static final String TOPIC_EMPLOYEE_SYNC_LOCATION = "dispatch.sync.employee.location.topic";

    /**
     * 目前只针对Sos的警情上报功能
     */
    public static final String TOPIC_NEW_POLICE_INCIDENT_REQUEST = "dispatch.sync.new.police.incident.topic";

    public static final String TOPIC_DEAD_LETTER_DISPATCH = "dispatch.dead.letter.dlt.topic";

    public static final String HEADER_ORIGINAL_TOPIC_NAME = "ORIGINAL_HEADER_TOPIC_NAME";

    /**
     * 签到: 涉及跨越电子围栏
     */
    public static final String TOPIC_DISPATCH_TENANT_EMPLOYEE_ATTENDANCE_RECORDS = "dispatch.binlog-cdc.topic.v2.tenant_employee_attendance_records";

    /**
     * 警情上报
     */
    public static final String TOPIC_DISPATCH_POLICE_INCIDENTS = "dispatch.binlog-cdc.topic.v2.police_incidents";

        /**
     * 考场表
     */
    public static final String TOPIC_TMS_TLK_EXAM_ROOM = "tms.binlog-cdc.topic.v2.tlk_exam_room";

    /**
     * 考试点表
     */
    public static final String TOPIC_TMS_TLK_EXAM_SITE = "tms.binlog-cdc.topic.v2.tlk_exam_site";

    /**
     * 考试表
     */
    public static final String TOPIC_TMS_TLK_SYSTEM_EXAM_INFO = "tms.binlog-cdc.topic.v2.tlk_system_exam_info";
    

    /**
     * 签到信息
     */
    public static final String TOPIC_DISPATCH_ATTENDANCE = "dispatch.binlog-cdc.topic.v2.attendance";

    /**
     * 点名轮换信息
     */
    public static final String TOPIC_DISPATCH_ROLL_CALL_RECORD = "dispatch.binlog-cdc.topic.v2.roll_call_record-v2";

    public static final String TOPIC_DISPATCH_ROLL_CALL_GE_TUI_LOG = "dispatch.binlog-cdc.topic.v2.roll_call_ge_tui_log-v2";

    public static final String TOPIC_DISPATCH_ROLL_CALL_GE_TUI_REQUEST = "dispatch.binlog-cdc.topic.v2.roll_call_ge_tui_request";

    /**
     * 监管归属信息
     */
    public static final String TOPIC_OBPM2_T_SUPERVISE_DEPARTMENT = "obpm2.binlog-cdc.topic.v2.t_supervise_department";

    /**
     * 内保关联的驻勤信息
     */
    public static final String TOPIC_BAIBAODUNFLOW_TLK_N_SECURITY = "baibaodunflow.binlog-cdc.topic.v2.tlk_n_security";

    /**
     * 内保单位信息变更(一般是指: 监管归属信息发生变化)-触发新的消息队列来更新相应的内容
     */
    public static final String TOPIC_DISPATCH_PROPRIETOR_COMPANY_CHANGED = "dispatch.binlog-cdc.topic.v2.proprietor.company.changed";

    public static final String TOPIC_DISPATCH_ROOM_EMPLOYEE_ACTION = "dispatch.room.employee.action.topic-v2";

    public static final String TOPIC_DISPATCH_ROLL_CALL_EMPLOYEE_ROOM = "dispatch.roll.call.room.employee.topic-v2";

    /**
     * 集团关系的数据权限
     */
    public static final String TOPIC_OBPM2_TENANT_DATA_PERMISSIONS = "obpm2.binlog-cdc.topic.v2.tenant_data_permissions";


    /**
     * 临保项目
     */
    public static final String TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_PROJECT = "baibaodunflow.binlog-cdc.topic.v2.tlk_temporary_protection_project";

    /**
     * 临保项目人员
     */
    public static final String TOPIC_BAIBAODUNFLOW_TLK_POST_PERSON = "baibaodunflow.binlog-cdc.topic.v2.tlk_post_person";

    /**
     * 临保项目管理小组
     */
    public static final String TOPIC_BAIBAODUNFLOW_TLK_TEMPORARY_PROTECTION_GROUP = "baibaodunflow.binlog-cdc.topic.v2.tlk_temporary_protection_group";

    public static final String TOPIC_DISPATCH_RD_DEVICE_SUMMARY = "dispatch.binlog-cdc.topic.v2.rd_device_summary";

    public static final String TOPIC_DISPATCH_TLK_HARDWARE = "dispatch.binlog-cdc.topic.v2.tlk_hardware";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_TYPE="baibaodunflow.binlog-cdc.topic.v2.tlk_project_person_type";


    public static final String TOPIC_BAIBAODUNFLOW_TLK_PROJECT_JOIN="baibaodunflow.binlog-cdc.topic.v2.tlk_project_join";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_MANAGE_POST="baibaodunflow.binlog-cdc.topic.v2.tlk_manage_post";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_PROJECT_PERSON_SOURCE="baibaodunflow.binlog-cdc.topic.v2.tlk_project_person_source";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_EVENT_POST="baibaodunflow.binlog-cdc.topic.v2.tlk_event_post";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_EVENT_TEAM_POWER="baibaodunflow.binlog-cdc.topic.v2.tlk_event_team_power";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_EVENT_TEAM="baibaodunflow.binlog-cdc.topic.v2.tlk_event_team";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_EVENT_PROJECT="baibaodunflow.binlog-cdc.topic.v2.tlk_event_project";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_ADD_WORK_DEMAND="baibaodunflow.binlog-cdc.topic.v2.tlk_add_work_demand";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_EVENT_MANAGER="baibaodunflow.binlog-cdc.topic.v2.tlk_event_manager";

    public static final String TOPIC_BAIBAODUNFLOW_TLK_EVENT_POST_MANAGER="baibaodunflow.binlog-cdc.topic.v2.tlk_event_post_manager";

    public static final String TOPIC_DISPATCH_RD_EMPLOYEE_SUMMARY = "dispatch.binlog-cdc.topic.v2.rd_employee_summary";

    public static final String TOPIC_DISPATCH_RD_EXAM_SITE_SUMMARY = "dispatch.binlog-cdc.topic.v2.rd_exam_site_summary";

    public static final String TOPIC_DISPATCH_RD_PROJECT_SUMMARY = "dispatch.binlog-cdc.topic.v2.rd_project_summary";

    public static final String TOPIC_DISPATCH_RD_SECURITY_STATION_SUMMARY = "dispatch.binlog-cdc.topic.v2.rd_security_station_summary";

    public static final String TOPIC_DISPATCH_RD_SECURITY_STATION_RAIL_SUMMARY = "dispatch.binlog-cdc.topic.v2.rd_security_station_rails";

    /**
     * 腾讯音视频回调信息
     */
    public static final String TOPIC_DISPATCH_TENCENT_CALLBACK = "dispatch.tencent.callback.topic";


    public static int calculatePartition(String value) {
        try {
            return Math.abs(value.hashCode() % KafkaConstants.PARTITION_COUNT);
        } catch (Exception ex) {
            return 0;
        }
    }
}
