/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.valueTypes;

import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.infrastructures.valueTypes.V5AttachmentValueType;
import com.bcxin.tenant.open.infrastructures.valueTypes.ValueTypeAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;

public class StationCodeValueType
extends ValueTypeAbstract {
    @Schema(name="code", title="\u9a7b\u52e4\u70b9\u7c7b\u578b/\u5de5\u4f5c\u7ec4\u7c7b\u578b")
    private String code;
    @Schema(name="name", title="\u540d\u79f0")
    private String name;
    @Schema(name="icon", title="\u5c97\u70b9\u5f39\u6846\u56fe\u6807; \u6ca1\u6709\u503c\u7684\u753b, \u53d6mapIcon\u7684\u53ef\u7528\u503c")
    private String icon;
    @Schema(name="mapIcon", title="\u5c97\u70b9\u6253\u70b9\u56fe\u6807; \u6ca1\u6709\u503c\u7684\u753b, \u4f7f\u7528\u9ed8\u8ba4\u56fe\u6807")
    private String mapIcon;
    @Schema(name="personOfflineMapIcon", title="\u79bb\u7ebf\u4eba\u5458\u56fe\u6807; \u6ca1\u6709\u503c\u7684\u753b, \u53d6personMapIcon\u7684\u53ef\u7528\u503c")
    private String personOfflineMapIcon;
    @Schema(name="personMapIcon", title="\u5728\u7ebf\u4eba\u5458\u56fe\u6807; \u6ca1\u6709\u503c\u7684\u753b, \u4f7f\u7528\u9ed8\u8ba4\u56fe\u6807")
    private String personMapIcon;
    private boolean onlyForStation;

    public static StationCodeValueType create(JsonProvider jsonProvider, String code, String name, String placeIconJson, String placeDetailIconJson, String personOfflineMapIcon, String personIconJson) {
        StationCodeValueType valueType = new StationCodeValueType();
        valueType.setCode(code);
        valueType.setName(name);
        valueType.setMapIcon(StationCodeValueType.extractActualPath(jsonProvider, placeIconJson));
        valueType.setIcon(StationCodeValueType.extractActualPath(jsonProvider, placeDetailIconJson));
        valueType.setPersonMapIcon(StationCodeValueType.extractActualPath(jsonProvider, personIconJson));
        valueType.setPersonOfflineMapIcon(StationCodeValueType.extractActualPath(jsonProvider, personOfflineMapIcon));
        return valueType;
    }

    private static String extractActualPath(JsonProvider jsonProvider, String jsonPath) {
        if (!StringUtil.isEmpty(jsonPath) && jsonPath.contains("[")) {
            try {
                Collection<V5AttachmentValueType> valueTypes;
                if (!StringUtil.isEmpty(jsonPath) && jsonPath.contains("[") && (valueTypes = jsonProvider.toObjects(V5AttachmentValueType.class, jsonPath)) != null) {
                    return valueTypes.stream().map(ii -> ii.getPath()).findFirst().orElse(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jsonPath;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getMapIcon() {
        return this.mapIcon;
    }

    public String getPersonOfflineMapIcon() {
        return this.personOfflineMapIcon;
    }

    public String getPersonMapIcon() {
        return this.personMapIcon;
    }

    public boolean isOnlyForStation() {
        return this.onlyForStation;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setMapIcon(String mapIcon) {
        this.mapIcon = mapIcon;
    }

    public void setPersonOfflineMapIcon(String personOfflineMapIcon) {
        this.personOfflineMapIcon = personOfflineMapIcon;
    }

    public void setPersonMapIcon(String personMapIcon) {
        this.personMapIcon = personMapIcon;
    }

    public void setOnlyForStation(boolean onlyForStation) {
        this.onlyForStation = onlyForStation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StationCodeValueType)) {
            return false;
        }
        StationCodeValueType other = (StationCodeValueType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOnlyForStation() != other.isOnlyForStation()) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$mapIcon = this.getMapIcon();
        String other$mapIcon = other.getMapIcon();
        if (this$mapIcon == null ? other$mapIcon != null : !this$mapIcon.equals(other$mapIcon)) {
            return false;
        }
        String this$personOfflineMapIcon = this.getPersonOfflineMapIcon();
        String other$personOfflineMapIcon = other.getPersonOfflineMapIcon();
        if (this$personOfflineMapIcon == null ? other$personOfflineMapIcon != null : !this$personOfflineMapIcon.equals(other$personOfflineMapIcon)) {
            return false;
        }
        String this$personMapIcon = this.getPersonMapIcon();
        String other$personMapIcon = other.getPersonMapIcon();
        return !(this$personMapIcon == null ? other$personMapIcon != null : !this$personMapIcon.equals(other$personMapIcon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StationCodeValueType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOnlyForStation() ? 79 : 97);
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $mapIcon = this.getMapIcon();
        result = result * 59 + ($mapIcon == null ? 43 : $mapIcon.hashCode());
        String $personOfflineMapIcon = this.getPersonOfflineMapIcon();
        result = result * 59 + ($personOfflineMapIcon == null ? 43 : $personOfflineMapIcon.hashCode());
        String $personMapIcon = this.getPersonMapIcon();
        result = result * 59 + ($personMapIcon == null ? 43 : $personMapIcon.hashCode());
        return result;
    }

    public String toString() {
        return "StationCodeValueType(code=" + this.getCode() + ", name=" + this.getName() + ", icon=" + this.getIcon() + ", mapIcon=" + this.getMapIcon() + ", personOfflineMapIcon=" + this.getPersonOfflineMapIcon() + ", personMapIcon=" + this.getPersonMapIcon() + ", onlyForStation=" + this.isOnlyForStation() + ")";
    }
}

