/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.infrastructures.enums;

import java.util.Collection;
import java.util.HashSet;

public enum RollCallType {
    RollCall(1, "\u70b9\u540d"),
    Dispatch(2, "\u7763\u5bfc\u70b9\u540d");

    String name;
    int value;

    private RollCallType(int value, String name) {
        this.name = name;
        this.value = value;
    }

    public static int calculate(Collection<RollCallType> callTypes) {
        int result = 0;
        if (callTypes != null && !callTypes.isEmpty()) {
            for (RollCallType rule : callTypes) {
                result |= rule.value;
            }
        }
        return result;
    }

    public static Collection<RollCallType> getSelectedRollCallTypes(int rollCallType) {
        HashSet<RollCallType> result = new HashSet<RollCallType>();
        for (RollCallType callType : RollCallType.values()) {
            if ((callType.value & rollCallType) <= 0) continue;
            result.add(callType);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }
}

