/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.services.impls;

import com.bcxin.tenant.open.document.domains.repositories.RoomDocumentRepository;
import com.bcxin.tenant.open.domains.BillPaymentRuleConfig;
import com.bcxin.tenant.open.domains.dtos.ProcessTencentCallbackLogDTO;
import com.bcxin.tenant.open.domains.dtos.RoomCommunicatedGroupDTO;
import com.bcxin.tenant.open.domains.entities.RoomUserEntity;
import com.bcxin.tenant.open.domains.entities.TencentCallbackLogEntity;
import com.bcxin.tenant.open.domains.events.PreparedRoomCommunicatedGroupEvent;
import com.bcxin.tenant.open.domains.repositories.RoomUserRepository;
import com.bcxin.tenant.open.domains.repositories.TencentCallbackLogRepository;
import com.bcxin.tenant.open.domains.services.TencentCallbackLogService;
import com.bcxin.tenant.open.domains.services.commands.CreateTencentCallbackLogCommand;
import com.bcxin.tenant.open.domains.services.commands.ProcessTencentCallbackLogCommand;
import com.bcxin.tenant.open.domains.utils.RoomCommunicatedGroupUtils;
import com.bcxin.tenant.open.domains.views.TencentCallbackLogView;
import com.bcxin.tenant.open.infrastructures.UnitWork;
import com.bcxin.tenant.open.infrastructures.components.IdWorker;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.enums.ProcessedStatus;
import com.bcxin.tenant.open.infrastructures.events.DomainEvent;
import com.bcxin.tenant.open.infrastructures.events.EventDispatcher;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.open.infrastructures.utils.NumberUtil;
import com.redis.om.spring.search.stream.EntityStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TencentCallbackLogServiceImpl
implements TencentCallbackLogService {
    private static final Logger logger = LoggerFactory.getLogger(TencentCallbackLogServiceImpl.class);
    private final TencentCallbackLogRepository tencentCallbackLogRepository;
    private final EventDispatcher eventDispatcher;
    private final RoomDocumentRepository roomDocumentRepository;
    private final RoomUserRepository roomUserRepository;
    private final JsonProvider jsonProvider;
    private final IdWorker idWorker;
    private final UnitWork unitWork;
    private final EntityStream entityStream;
    private final BillPaymentRuleConfig billPaymentRuleConfig;

    public TencentCallbackLogServiceImpl(TencentCallbackLogRepository tencentCallbackLogRepository, EventDispatcher eventDispatcher, RoomDocumentRepository roomDocumentRepository, RoomUserRepository roomUserRepository, JsonProvider jsonProvider, IdWorker idWorker, UnitWork unitWork, EntityStream entityStream, BillPaymentRuleConfig billPaymentRuleConfig) {
        this.tencentCallbackLogRepository = tencentCallbackLogRepository;
        this.eventDispatcher = eventDispatcher;
        this.roomUserRepository = roomUserRepository;
        this.jsonProvider = jsonProvider;
        this.unitWork = unitWork;
        this.idWorker = idWorker;
        this.entityStream = entityStream;
        this.roomDocumentRepository = roomDocumentRepository;
        this.billPaymentRuleConfig = billPaymentRuleConfig;
    }

    @Override
    public void dispatch(CreateTencentCallbackLogCommand command) {
        Long eventGroupId = NumberUtil.toLong((Object)this.getByKey(command.getData(), "EventGroupId"));
        Integer eventType = NumberUtil.toInteger((Object)this.getByKey(command.getData(), "EventType"));
        Long callbackTs = NumberUtil.toLong((Object)this.getByKey(command.getData(), "CallbackTs"));
        Map eventInfo = (Map)this.getByKey(command.getData(), "EventInfo");
        String userId = null;
        String roomId = null;
        if (eventInfo != null) {
            userId = String.valueOf(this.getByKey(eventInfo, "UserId"));
            roomId = String.valueOf(this.getByKey(eventInfo, "RoomId"));
        }
        String sdkAppId = (String)this.getByKey(command.getData(), "SdkAppId");
        TencentCallbackLogEntity entity = TencentCallbackLogEntity.create(eventGroupId, eventType, callbackTs, this.jsonProvider.getJson((Object)eventInfo), userId, roomId, sdkAppId);
        this.tencentCallbackLogRepository.insert(entity);
    }

    @Override
    public void dispatch(ProcessTencentCallbackLogCommand command) {
        if (CollectionUtils.isEmpty(command.getRoomIds())) {
            return;
        }
        Collection roomIds = command.getRoomIds().stream().distinct().collect(Collectors.toList());
        logger.info("\u5df2\u7ecf\u63a8\u51fa\u5e76\u6ee1\u8db3\u7b26\u5408\u6761\u4ef6\u7684\u623f\u95f4Ids={}", (Object)roomIds);
        Collection<TencentCallbackLogView> roomRelatedData = this.tencentCallbackLogRepository.getAllPendingLogsByRoomIds(roomIds);
        Collection<RoomUserEntity> roomUsers = this.roomUserRepository.getRoomUsersByRoomIds(roomIds);
        Collection<RoomCommunicatedGroupDTO> communicatedGroups = RoomCommunicatedGroupUtils.build(this.roomDocumentRepository, this.jsonProvider, roomIds, roomRelatedData, roomUsers, this.entityStream, this.billPaymentRuleConfig);
        RoomCommunicatedGroupUtils.appendNoApplyRoomUsers(this.idWorker, communicatedGroups, roomUsers);
        if (CollectionUtils.isEmpty(communicatedGroups)) {
            String error = RoomCommunicatedGroupUtils.getCurrentProcessError();
            this.processErrorRoomIds(roomIds, StringUtils.hasLength((String)error) ? error : "1.\u65e0\u6548\u6570\u636e\u6216\u8005\u65e0\u6548\u623f\u95f4\u6570\u636e, \u65e0\u6cd5\u627e\u5230\u5f00\u542f\u623f\u95f4\u7684\u53d1\u8d77\u4eba\u4fe1\u606f[RoomCommunicatedGroupUtils.build]");
            return;
        }
        Collection invalidRoomIds = roomIds.stream().filter(ix -> !communicatedGroups.stream().anyMatch(iz -> iz.getRoomId().equalsIgnoreCase(String.valueOf(ix)))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)invalidRoomIds)) {
            String error = RoomCommunicatedGroupUtils.getCurrentProcessError();
            this.processErrorRoomIds(invalidRoomIds, StringUtils.hasLength((String)error) ? error : "2.\u65e0\u6548\u6570\u636e\u6216\u8005\u65e0\u6548\u623f\u95f4\u6570\u636e, \u65e0\u6cd5\u627e\u5230\u5f00\u542f\u623f\u95f4\u7684\u53d1\u8d77\u4eba\u4fe1\u606f[RoomCommunicatedGroupUtils.build]");
        }
        for (Long selectedRoomId : roomIds) {
            Collection selectedCommunicatedGroups = communicatedGroups.stream().filter(ix -> ix.getRoomId().equalsIgnoreCase(String.valueOf(selectedRoomId))).collect(Collectors.toList());
            if (selectedCommunicatedGroups.size() > 1) {
                throw new BadTenantException("\u4e00\u4e2a\u623f\u95f4\u4e0d\u5e94\u8be5\u5b58\u5728\u591a\u4e2aRoomCommunicatedGroup\u5bf9\u8c61");
            }
            try {
                this.processDispatch(selectedCommunicatedGroups.stream().findFirst().orElse(null), selectedRoomId);
            }
            catch (Exception ex) {
                this.processErrorRoomIds(Collections.singleton(selectedRoomId), ExceptionUtil.getStackMessage((Throwable)ex));
                logger.error("\u623f\u95f4\u4fe1\u606f\u8ba1\u7b97\u9519\u8bef:{};\u5f02\u5e38:{}", (Object)selectedRoomId, (Object)ExceptionUtil.getStackMessage((Throwable)ex));
            }
        }
    }

    public void processDispatch(RoomCommunicatedGroupDTO cg, Long selectedRoomId) {
        StringBuilder error = new StringBuilder();
        String tranId = this.unitWork.beginTransaction();
        Set<Long> roomIds = Collections.singleton(selectedRoomId);
        try {
            Set<RoomCommunicatedGroupDTO> communicatedGroups = Collections.singleton(cg);
            logger.info("\u6784\u5efa\u7684\u4ea4\u6d41\u623f\u95f4\u6570\u91cf={}", (Object)communicatedGroups.size());
            ProcessTencentCallbackLogDTO processTencentCallbackLogDTO = null;
            if (CollectionUtils.isEmpty(cg.getAudioVideoLogs())) {
                processTencentCallbackLogDTO = ProcessTencentCallbackLogDTO.create(roomIds, ProcessedStatus.Done, "\u8be5\u623f\u95f4\u672a\u5f00\u59cb\u97f3\u89c6\u9891\u7684\u8c03\u5ea6");
            } else if (CollectionUtils.isEmpty(cg.getJoinRoomUsers())) {
                processTencentCallbackLogDTO = ProcessTencentCallbackLogDTO.create(roomIds, ProcessedStatus.Done, "\u8be5\u623f\u95f4\u672a\u6709\u4eba\u5458\u53c2\u4e0e\u8fdb\u6765");
            } else {
                this.eventDispatcher.dispatch((DomainEvent)PreparedRoomCommunicatedGroupEvent.create(communicatedGroups));
                processTencentCallbackLogDTO = ProcessTencentCallbackLogDTO.create(roomIds, ProcessedStatus.Done, "\u5b8c\u6210");
            }
            this.tencentCallbackLogRepository.process(processTencentCallbackLogDTO);
            this.unitWork.commit(tranId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.unitWork.rollback(tranId);
            tranId = this.unitWork.beginTransaction();
            try {
                ProcessTencentCallbackLogDTO processTencentCallbackLogDTO = ProcessTencentCallbackLogDTO.create(roomIds, ProcessedStatus.Error, ExceptionUtil.getStackMessage((Throwable)ex));
                this.tencentCallbackLogRepository.process(processTencentCallbackLogDTO);
                this.unitWork.commit(tranId);
            }
            catch (Exception e) {
                this.unitWork.rollback(tranId);
                e.printStackTrace();
            }
            error.append(String.format("\u6267\u884c\u623f\u95f4(%s) \u53d1\u751f\u5f02\u5e38:%s;", cg.getRoomId(), ExceptionUtil.getStackMessage((Throwable)ex)));
        }
        if (error.length() > 1) {
            throw new BadTenantException(error.toString());
        }
    }

    public void processErrorRoomIds(Collection<Long> roomIds, String ex) {
        String tranId = this.unitWork.beginTransaction();
        try {
            ProcessTencentCallbackLogDTO processTencentCallbackLogDTO = ProcessTencentCallbackLogDTO.create(roomIds, ProcessedStatus.Error, ex);
            this.tencentCallbackLogRepository.process(processTencentCallbackLogDTO);
            this.unitWork.commit(tranId);
        }
        catch (Exception e) {
            this.unitWork.rollback(tranId);
            e.printStackTrace();
        }
    }

    private Object getByKey(Map<String, Object> data, String key) {
        if (key == null || data == null) {
            return null;
        }
        Optional<Object> valueOptional = data.entrySet().stream().filter(ix -> ((String)ix.getKey()).equalsIgnoreCase(key) && ix.getValue() != null).map(ix -> ix.getValue()).findFirst();
        if (valueOptional.isPresent()) {
            return valueOptional.get();
        }
        return null;
    }
}

