/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.domains.entities;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.bcxin.tenant.open.domains.entities.RollCallEmployeeHistoryEntity;
import com.bcxin.tenant.open.domains.entities.RollCallEntity;
import com.bcxin.tenant.open.domains.pojo.OrganizationPoJo;
import com.bcxin.tenant.open.domains.pojo.RollCallRulePoJo;
import com.bcxin.tenant.open.domains.pojo.SecurityDepartPoJo;
import com.bcxin.tenant.open.domains.pojo.SecurityStationPoJo;
import com.bcxin.tenant.open.infrastructures.components.JsonProvider;
import com.bcxin.tenant.open.infrastructures.entities.Aggregate;
import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import com.bcxin.tenant.open.infrastructures.exceptions.IgnoreTenantException;
import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.springframework.util.StringUtils;

@TableName(value="vga_roll_call_employees", autoResultMap=true)
public class RollCallEmployeeEntity
extends EntityAbstract
implements Aggregate {
    @TableId(value="id")
    private String id;
    @TableField(value="roll_call_id")
    private Long rollCallId;
    @TableField(value="roll_call_plan_id")
    private Long rollCallPlanId;
    @TableField(value="security_station_json")
    private String securityStationJson;
    @TableField(value="security_depart_json")
    private String securityDepartJson;
    @TableField(value="created_time")
    private Timestamp createdTime;
    @TableField(value="called_employee_id")
    private String calledEmployeeId;
    @TableField(value="called_tenant_user_cid")
    private String calledTenantUserCid;
    @TableField(value="last_updated_tenant_user_cid_time")
    private Timestamp lastUpdatedTenantUserCIdTime;
    @TableField(value="called_tenant_user_id")
    private String calledTenantUserId;
    @TableField(value="called_tencent_user_id")
    private String calledTencentUserId;
    @TableField(value="called_organization_id")
    private String calledOrganizationId;
    @TableField(value="called_organization_name")
    private String calledOrganizationName;
    @TableField(value="called_employee_name")
    private String calledEmployeeName;
    @TableField(value="call_type")
    private int callType;
    @TableField(value="status")
    private int status;
    @TableField(value="last_roll_call_status_changed_time")
    private Timestamp lastRollCallStatusTime;
    @TableField(value="last_roll_call_status_changed_note")
    private String lastRollCallStatusNote;
    @TableField(value="action_organization_id")
    private String actionOrganizationId;
    @TableField(value="action_organization_name")
    private String actionOrganizationName;
    @TableField(value="action_employee_id")
    private String actionEmployeeId;
    @TableField(value="action_employee_name")
    private String actionEmployeeName;
    @TableField(value="last_action_time")
    private Timestamp lastActionTime;
    @TableField(value="last_room_id")
    private String lastRoomId;
    @TableField(value="last_room_time")
    private Timestamp lastRoomTime;

    public RollCallEmployeeEntity() {
        this.setCreatedTime(Timestamp.from(Instant.now()));
        this.setLastActionTime(this.getCreatedTime());
        this.setStatus(RollCallStatus.calculate(Collections.singleton(RollCallStatus.RollCallInit)));
    }

    public Collection<RollCallEmployeeHistoryEntity> reply(RollCallType rollCallType, String roomId, RollCallStatus expectedStatus) {
        Collection selectedStatuses;
        if (!StringUtils.hasLength((String)roomId) && rollCallType == RollCallType.Dispatch) {
            throw new BadTenantException("\u56de\u590d\u7763\u5bfc\u70b9\u540d\u7684\u65f6\u5019, \u623f\u95f4(RoomId)\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<RollCallEmployeeHistoryEntity> employeeHistories = new ArrayList<RollCallEmployeeHistoryEntity>();
        Collection currentRollCallTypes = RollCallType.getSelectedRollCallTypes((int)this.getCallType());
        if (!currentRollCallTypes.contains(rollCallType)) {
            if (rollCallType == RollCallType.Dispatch) {
                currentRollCallTypes.add(RollCallType.Dispatch);
                this.setCallType(RollCallType.calculate((Collection)currentRollCallTypes));
                RollCallEmployeeHistoryEntity unexpectedHistory = RollCallEmployeeHistoryEntity.create(rollCallType, roomId, this, RollCallStatus.DispatchInit, "\u975e\u9884\u671f\u7684\u7763\u5bfc\u70b9\u540d\u7684\u521d\u59cb\u5316-\u5728\u786e\u8ba4\u7684\u65f6\u5019\u6267\u884c");
                employeeHistories.add(unexpectedHistory);
            }
            if (rollCallType == RollCallType.RollCall) {
                throw new BadTenantException("\u7cfb\u7edf\u5f02\u5e38; \u672a\u627e\u5230\u70b9\u540d\u4fe1\u606f\u8bb0\u5f55;");
            }
        }
        if ((selectedStatuses = RollCallStatus.getSelectedRollCallStatuses((int)this.getStatus())).contains(expectedStatus)) {
            throw new IgnoreTenantException("\u8be5\u64cd\u4f5c\u5df2\u786e\u8ba4; \u4e0d\u5141\u8bb8\u91cd\u590d\u63d0\u4ea4");
        }
        if (expectedStatus == RollCallStatus.RollCallSuccess || expectedStatus == RollCallStatus.DispatchSuccess) {
            if (rollCallType == RollCallType.RollCall) {
                if (selectedStatuses.contains(RollCallStatus.RollCallFailed)) {
                    throw new BadTenantException("\u8be5\u8f6e\u70b9\u540d\u5df2\u7ecf\u7ed3\u675f, \u65e0\u6cd5\u8fdb\u884c\u786e\u8ba4");
                }
            } else if (rollCallType == RollCallType.Dispatch && selectedStatuses.contains(RollCallStatus.DispatchFailed)) {
                throw new BadTenantException("\u8be5\u7763\u5bfc\u70b9\u540d\u5df2\u7ecf\u7ed3\u675f, \u65e0\u6cd5\u8fdb\u884c\u786e\u8ba4");
            }
        }
        Collection remainStatuses = RollCallStatus.calculateRollCallStatus((Collection)selectedStatuses, (RollCallStatus)expectedStatus);
        remainStatuses.add(expectedStatus);
        this.setStatus(RollCallStatus.calculate((Collection)remainStatuses));
        Timestamp now = Timestamp.from(Instant.now());
        this.setLastRoomId(roomId);
        this.setLastRoomTime(now);
        this.setLastRollCallStatusTime(now);
        String label = "\u5df2\u786e\u8ba4";
        if (expectedStatus == RollCallStatus.RollCallFailed) {
            label = "\u7763\u5bfc\u70b9\u540d\u5931\u8d25";
        }
        this.setLastRollCallStatusNote(label);
        RollCallEmployeeHistoryEntity history = RollCallEmployeeHistoryEntity.create(rollCallType, roomId, this, expectedStatus, label);
        employeeHistories.add(history);
        return employeeHistories;
    }

    public RollCallEmployeeHistoryEntity assignFailed2Call(RollCallType rollCallType, RollCallStatus status, String message) {
        Collection selectedStatuses = RollCallStatus.getSelectedRollCallStatuses((int)this.getStatus());
        if (status == RollCallStatus.RollCallFailed && selectedStatuses.contains(RollCallStatus.RollCallSuccess)) {
            return null;
        }
        if (status == RollCallStatus.DispatchFailed && selectedStatuses.contains(RollCallStatus.DispatchSuccess)) {
            return null;
        }
        Collection remainStatuses = RollCallStatus.calculateRollCallStatus((Collection)selectedStatuses, (RollCallStatus)status);
        this.setStatus(RollCallStatus.calculate((Collection)remainStatuses));
        this.setLastRollCallStatusTime(Timestamp.from(Instant.now()));
        this.setLastRollCallStatusNote(message);
        return RollCallEmployeeHistoryEntity.create(rollCallType, this, status, message);
    }

    public Collection<RollCallEmployeeHistoryEntity> autoFailed(String message) {
        RollCallEmployeeHistoryEntity history;
        Collection selectedRolLCallType = RollCallType.getSelectedRollCallTypes((int)this.getCallType());
        ArrayList<RollCallEmployeeHistoryEntity> histories = new ArrayList<RollCallEmployeeHistoryEntity>();
        if (selectedRolLCallType.contains(RollCallType.Dispatch)) {
            RollCallEmployeeHistoryEntity history2;
            Calendar currentCalendar = Calendar.getInstance();
            currentCalendar.add(12, -3);
            Date shouldBeExpiredTime = currentCalendar.getTime();
            if (this.getLastActionTime() != null && this.getLastActionTime().before(shouldBeExpiredTime) && (history2 = this.assignFailed2Call(RollCallType.Dispatch, RollCallStatus.DispatchFailed, message)) != null) {
                histories.add(history2);
            }
        }
        if (selectedRolLCallType.contains(RollCallType.RollCall) && (history = this.assignFailed2Call(RollCallType.RollCall, RollCallStatus.RollCallFailed, message)) != null) {
            histories.add(history);
        }
        return histories;
    }

    public void assignCalledTenantCid(String cid) {
        this.setCalledTenantUserCid(cid);
        this.setLastUpdatedTenantUserCIdTime(Timestamp.from(Instant.now()));
        this.setLastRollCallStatusNote("\u63a8\u9001\u7ed9\u624b\u673aCID");
    }

    public RollCallEmployeeHistoryEntity doDispatch(String roomId) {
        if (StringUtils.hasLength((String)this.getLastRoomId()) && StringUtil.isEqual((String)this.getLastRoomId(), (String)roomId)) {
            return null;
        }
        this.setLastRoomId(roomId);
        Timestamp now = Timestamp.from(Instant.now());
        this.setLastRoomTime(now);
        this.setLastRollCallStatusTime(now);
        this.setLastActionTime(now);
        Collection selectedCallTypes = RollCallType.getSelectedRollCallTypes((int)this.getCallType());
        selectedCallTypes.add(RollCallType.Dispatch);
        this.setCallType(RollCallType.calculate((Collection)selectedCallTypes));
        RollCallStatus expectedStatus = RollCallStatus.DispatchInit;
        Collection selectedStatuses = RollCallStatus.getSelectedRollCallStatuses((int)this.getStatus());
        Collection remainStatuses = RollCallStatus.calculateRollCallStatus((Collection)selectedStatuses, (RollCallStatus)expectedStatus);
        this.setStatus(RollCallStatus.calculate((Collection)remainStatuses));
        this.setLastRollCallStatusNote("\u53d1\u8d77\u7763\u5bfc\u70b9\u540d\u8bf7\u6c42");
        return RollCallEmployeeHistoryEntity.create(RollCallType.Dispatch, roomId, this, expectedStatus, "\u53d1\u8d77\u7763\u5bfc\u70b9\u540d\u8bf7\u6c42");
    }

    public static RollCallEmployeeEntity create(String id, JsonProvider jsonProvider, RollCallEntity rollCall, String calledEmployeeId, String calledTenantUserId, String calledTencentUserId, String calledEmployeeName, SecurityDepartPoJo securityDepartPoJo, SecurityStationPoJo securityStationPoJo, OrganizationPoJo organizationPoJo) {
        RollCallEmployeeEntity entity = new RollCallEmployeeEntity();
        entity.setActionEmployeeId(rollCall.getActionEmployeeId());
        entity.setActionEmployeeName(rollCall.getActionEmployeeName());
        entity.setActionOrganizationId(rollCall.getActionOrganizationId());
        entity.setActionOrganizationName(rollCall.getActionOrganizationName());
        entity.setRollCallId(rollCall.getId());
        RollCallRulePoJo rulePoJo = (RollCallRulePoJo)jsonProvider.toObject(RollCallRulePoJo.class, rollCall.getRollCallRuleJson());
        if (rulePoJo != null) {
            entity.setRollCallPlanId(rulePoJo.getPlanId());
        }
        entity.setId(id);
        entity.setCallType(RollCallType.calculate(Collections.singleton(RollCallType.RollCall)));
        entity.setCalledEmployeeId(calledEmployeeId);
        entity.setCalledTenantUserId(calledTenantUserId);
        entity.setCalledTencentUserId(calledTencentUserId);
        entity.setCalledEmployeeName(calledEmployeeName);
        entity.setSecurityDepartJson(jsonProvider.getJson((Object)securityDepartPoJo));
        entity.setSecurityStationJson(jsonProvider.getJson((Object)securityStationPoJo));
        entity.setCalledOrganizationId(organizationPoJo.getId());
        entity.setCalledOrganizationName(organizationPoJo.getName());
        entity.setCreatedTime(rollCall.getCreatedTime());
        return entity;
    }

    public String getId() {
        return this.id;
    }

    public Long getRollCallId() {
        return this.rollCallId;
    }

    public Long getRollCallPlanId() {
        return this.rollCallPlanId;
    }

    public String getSecurityStationJson() {
        return this.securityStationJson;
    }

    public String getSecurityDepartJson() {
        return this.securityDepartJson;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public String getCalledEmployeeId() {
        return this.calledEmployeeId;
    }

    public String getCalledTenantUserCid() {
        return this.calledTenantUserCid;
    }

    public Timestamp getLastUpdatedTenantUserCIdTime() {
        return this.lastUpdatedTenantUserCIdTime;
    }

    public String getCalledTenantUserId() {
        return this.calledTenantUserId;
    }

    public String getCalledTencentUserId() {
        return this.calledTencentUserId;
    }

    public String getCalledOrganizationId() {
        return this.calledOrganizationId;
    }

    public String getCalledOrganizationName() {
        return this.calledOrganizationName;
    }

    public String getCalledEmployeeName() {
        return this.calledEmployeeName;
    }

    public int getCallType() {
        return this.callType;
    }

    public int getStatus() {
        return this.status;
    }

    public Timestamp getLastRollCallStatusTime() {
        return this.lastRollCallStatusTime;
    }

    public String getLastRollCallStatusNote() {
        return this.lastRollCallStatusNote;
    }

    public String getActionOrganizationId() {
        return this.actionOrganizationId;
    }

    public String getActionOrganizationName() {
        return this.actionOrganizationName;
    }

    public String getActionEmployeeId() {
        return this.actionEmployeeId;
    }

    public String getActionEmployeeName() {
        return this.actionEmployeeName;
    }

    public Timestamp getLastActionTime() {
        return this.lastActionTime;
    }

    public String getLastRoomId() {
        return this.lastRoomId;
    }

    public Timestamp getLastRoomTime() {
        return this.lastRoomTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRollCallId(Long rollCallId) {
        this.rollCallId = rollCallId;
    }

    public void setRollCallPlanId(Long rollCallPlanId) {
        this.rollCallPlanId = rollCallPlanId;
    }

    public void setSecurityStationJson(String securityStationJson) {
        this.securityStationJson = securityStationJson;
    }

    public void setSecurityDepartJson(String securityDepartJson) {
        this.securityDepartJson = securityDepartJson;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public void setCalledEmployeeId(String calledEmployeeId) {
        this.calledEmployeeId = calledEmployeeId;
    }

    public void setCalledTenantUserCid(String calledTenantUserCid) {
        this.calledTenantUserCid = calledTenantUserCid;
    }

    public void setLastUpdatedTenantUserCIdTime(Timestamp lastUpdatedTenantUserCIdTime) {
        this.lastUpdatedTenantUserCIdTime = lastUpdatedTenantUserCIdTime;
    }

    public void setCalledTenantUserId(String calledTenantUserId) {
        this.calledTenantUserId = calledTenantUserId;
    }

    public void setCalledTencentUserId(String calledTencentUserId) {
        this.calledTencentUserId = calledTencentUserId;
    }

    public void setCalledOrganizationId(String calledOrganizationId) {
        this.calledOrganizationId = calledOrganizationId;
    }

    public void setCalledOrganizationName(String calledOrganizationName) {
        this.calledOrganizationName = calledOrganizationName;
    }

    public void setCalledEmployeeName(String calledEmployeeName) {
        this.calledEmployeeName = calledEmployeeName;
    }

    public void setCallType(int callType) {
        this.callType = callType;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setLastRollCallStatusTime(Timestamp lastRollCallStatusTime) {
        this.lastRollCallStatusTime = lastRollCallStatusTime;
    }

    public void setLastRollCallStatusNote(String lastRollCallStatusNote) {
        this.lastRollCallStatusNote = lastRollCallStatusNote;
    }

    public void setActionOrganizationId(String actionOrganizationId) {
        this.actionOrganizationId = actionOrganizationId;
    }

    public void setActionOrganizationName(String actionOrganizationName) {
        this.actionOrganizationName = actionOrganizationName;
    }

    public void setActionEmployeeId(String actionEmployeeId) {
        this.actionEmployeeId = actionEmployeeId;
    }

    public void setActionEmployeeName(String actionEmployeeName) {
        this.actionEmployeeName = actionEmployeeName;
    }

    public void setLastActionTime(Timestamp lastActionTime) {
        this.lastActionTime = lastActionTime;
    }

    public void setLastRoomId(String lastRoomId) {
        this.lastRoomId = lastRoomId;
    }

    public void setLastRoomTime(Timestamp lastRoomTime) {
        this.lastRoomTime = lastRoomTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollCallEmployeeEntity)) {
            return false;
        }
        RollCallEmployeeEntity other = (RollCallEmployeeEntity)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getCallType() != other.getCallType()) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Long this$rollCallId = this.getRollCallId();
        Long other$rollCallId = other.getRollCallId();
        if (this$rollCallId == null ? other$rollCallId != null : !((Object)this$rollCallId).equals(other$rollCallId)) {
            return false;
        }
        Long this$rollCallPlanId = this.getRollCallPlanId();
        Long other$rollCallPlanId = other.getRollCallPlanId();
        if (this$rollCallPlanId == null ? other$rollCallPlanId != null : !((Object)this$rollCallPlanId).equals(other$rollCallPlanId)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$securityStationJson = this.getSecurityStationJson();
        String other$securityStationJson = other.getSecurityStationJson();
        if (this$securityStationJson == null ? other$securityStationJson != null : !this$securityStationJson.equals(other$securityStationJson)) {
            return false;
        }
        String this$securityDepartJson = this.getSecurityDepartJson();
        String other$securityDepartJson = other.getSecurityDepartJson();
        if (this$securityDepartJson == null ? other$securityDepartJson != null : !this$securityDepartJson.equals(other$securityDepartJson)) {
            return false;
        }
        Timestamp this$createdTime = this.getCreatedTime();
        Timestamp other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$calledEmployeeId = this.getCalledEmployeeId();
        String other$calledEmployeeId = other.getCalledEmployeeId();
        if (this$calledEmployeeId == null ? other$calledEmployeeId != null : !this$calledEmployeeId.equals(other$calledEmployeeId)) {
            return false;
        }
        String this$calledTenantUserCid = this.getCalledTenantUserCid();
        String other$calledTenantUserCid = other.getCalledTenantUserCid();
        if (this$calledTenantUserCid == null ? other$calledTenantUserCid != null : !this$calledTenantUserCid.equals(other$calledTenantUserCid)) {
            return false;
        }
        Timestamp this$lastUpdatedTenantUserCIdTime = this.getLastUpdatedTenantUserCIdTime();
        Timestamp other$lastUpdatedTenantUserCIdTime = other.getLastUpdatedTenantUserCIdTime();
        if (this$lastUpdatedTenantUserCIdTime == null ? other$lastUpdatedTenantUserCIdTime != null : !((Object)this$lastUpdatedTenantUserCIdTime).equals(other$lastUpdatedTenantUserCIdTime)) {
            return false;
        }
        String this$calledTenantUserId = this.getCalledTenantUserId();
        String other$calledTenantUserId = other.getCalledTenantUserId();
        if (this$calledTenantUserId == null ? other$calledTenantUserId != null : !this$calledTenantUserId.equals(other$calledTenantUserId)) {
            return false;
        }
        String this$calledTencentUserId = this.getCalledTencentUserId();
        String other$calledTencentUserId = other.getCalledTencentUserId();
        if (this$calledTencentUserId == null ? other$calledTencentUserId != null : !this$calledTencentUserId.equals(other$calledTencentUserId)) {
            return false;
        }
        String this$calledOrganizationId = this.getCalledOrganizationId();
        String other$calledOrganizationId = other.getCalledOrganizationId();
        if (this$calledOrganizationId == null ? other$calledOrganizationId != null : !this$calledOrganizationId.equals(other$calledOrganizationId)) {
            return false;
        }
        String this$calledOrganizationName = this.getCalledOrganizationName();
        String other$calledOrganizationName = other.getCalledOrganizationName();
        if (this$calledOrganizationName == null ? other$calledOrganizationName != null : !this$calledOrganizationName.equals(other$calledOrganizationName)) {
            return false;
        }
        String this$calledEmployeeName = this.getCalledEmployeeName();
        String other$calledEmployeeName = other.getCalledEmployeeName();
        if (this$calledEmployeeName == null ? other$calledEmployeeName != null : !this$calledEmployeeName.equals(other$calledEmployeeName)) {
            return false;
        }
        Timestamp this$lastRollCallStatusTime = this.getLastRollCallStatusTime();
        Timestamp other$lastRollCallStatusTime = other.getLastRollCallStatusTime();
        if (this$lastRollCallStatusTime == null ? other$lastRollCallStatusTime != null : !((Object)this$lastRollCallStatusTime).equals(other$lastRollCallStatusTime)) {
            return false;
        }
        String this$lastRollCallStatusNote = this.getLastRollCallStatusNote();
        String other$lastRollCallStatusNote = other.getLastRollCallStatusNote();
        if (this$lastRollCallStatusNote == null ? other$lastRollCallStatusNote != null : !this$lastRollCallStatusNote.equals(other$lastRollCallStatusNote)) {
            return false;
        }
        String this$actionOrganizationId = this.getActionOrganizationId();
        String other$actionOrganizationId = other.getActionOrganizationId();
        if (this$actionOrganizationId == null ? other$actionOrganizationId != null : !this$actionOrganizationId.equals(other$actionOrganizationId)) {
            return false;
        }
        String this$actionOrganizationName = this.getActionOrganizationName();
        String other$actionOrganizationName = other.getActionOrganizationName();
        if (this$actionOrganizationName == null ? other$actionOrganizationName != null : !this$actionOrganizationName.equals(other$actionOrganizationName)) {
            return false;
        }
        String this$actionEmployeeId = this.getActionEmployeeId();
        String other$actionEmployeeId = other.getActionEmployeeId();
        if (this$actionEmployeeId == null ? other$actionEmployeeId != null : !this$actionEmployeeId.equals(other$actionEmployeeId)) {
            return false;
        }
        String this$actionEmployeeName = this.getActionEmployeeName();
        String other$actionEmployeeName = other.getActionEmployeeName();
        if (this$actionEmployeeName == null ? other$actionEmployeeName != null : !this$actionEmployeeName.equals(other$actionEmployeeName)) {
            return false;
        }
        Timestamp this$lastActionTime = this.getLastActionTime();
        Timestamp other$lastActionTime = other.getLastActionTime();
        if (this$lastActionTime == null ? other$lastActionTime != null : !((Object)this$lastActionTime).equals(other$lastActionTime)) {
            return false;
        }
        String this$lastRoomId = this.getLastRoomId();
        String other$lastRoomId = other.getLastRoomId();
        if (this$lastRoomId == null ? other$lastRoomId != null : !this$lastRoomId.equals(other$lastRoomId)) {
            return false;
        }
        Timestamp this$lastRoomTime = this.getLastRoomTime();
        Timestamp other$lastRoomTime = other.getLastRoomTime();
        return !(this$lastRoomTime == null ? other$lastRoomTime != null : !((Object)this$lastRoomTime).equals(other$lastRoomTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RollCallEmployeeEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCallType();
        result = result * 59 + this.getStatus();
        Long $rollCallId = this.getRollCallId();
        result = result * 59 + ($rollCallId == null ? 43 : ((Object)$rollCallId).hashCode());
        Long $rollCallPlanId = this.getRollCallPlanId();
        result = result * 59 + ($rollCallPlanId == null ? 43 : ((Object)$rollCallPlanId).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $securityStationJson = this.getSecurityStationJson();
        result = result * 59 + ($securityStationJson == null ? 43 : $securityStationJson.hashCode());
        String $securityDepartJson = this.getSecurityDepartJson();
        result = result * 59 + ($securityDepartJson == null ? 43 : $securityDepartJson.hashCode());
        Timestamp $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $calledEmployeeId = this.getCalledEmployeeId();
        result = result * 59 + ($calledEmployeeId == null ? 43 : $calledEmployeeId.hashCode());
        String $calledTenantUserCid = this.getCalledTenantUserCid();
        result = result * 59 + ($calledTenantUserCid == null ? 43 : $calledTenantUserCid.hashCode());
        Timestamp $lastUpdatedTenantUserCIdTime = this.getLastUpdatedTenantUserCIdTime();
        result = result * 59 + ($lastUpdatedTenantUserCIdTime == null ? 43 : ((Object)$lastUpdatedTenantUserCIdTime).hashCode());
        String $calledTenantUserId = this.getCalledTenantUserId();
        result = result * 59 + ($calledTenantUserId == null ? 43 : $calledTenantUserId.hashCode());
        String $calledTencentUserId = this.getCalledTencentUserId();
        result = result * 59 + ($calledTencentUserId == null ? 43 : $calledTencentUserId.hashCode());
        String $calledOrganizationId = this.getCalledOrganizationId();
        result = result * 59 + ($calledOrganizationId == null ? 43 : $calledOrganizationId.hashCode());
        String $calledOrganizationName = this.getCalledOrganizationName();
        result = result * 59 + ($calledOrganizationName == null ? 43 : $calledOrganizationName.hashCode());
        String $calledEmployeeName = this.getCalledEmployeeName();
        result = result * 59 + ($calledEmployeeName == null ? 43 : $calledEmployeeName.hashCode());
        Timestamp $lastRollCallStatusTime = this.getLastRollCallStatusTime();
        result = result * 59 + ($lastRollCallStatusTime == null ? 43 : ((Object)$lastRollCallStatusTime).hashCode());
        String $lastRollCallStatusNote = this.getLastRollCallStatusNote();
        result = result * 59 + ($lastRollCallStatusNote == null ? 43 : $lastRollCallStatusNote.hashCode());
        String $actionOrganizationId = this.getActionOrganizationId();
        result = result * 59 + ($actionOrganizationId == null ? 43 : $actionOrganizationId.hashCode());
        String $actionOrganizationName = this.getActionOrganizationName();
        result = result * 59 + ($actionOrganizationName == null ? 43 : $actionOrganizationName.hashCode());
        String $actionEmployeeId = this.getActionEmployeeId();
        result = result * 59 + ($actionEmployeeId == null ? 43 : $actionEmployeeId.hashCode());
        String $actionEmployeeName = this.getActionEmployeeName();
        result = result * 59 + ($actionEmployeeName == null ? 43 : $actionEmployeeName.hashCode());
        Timestamp $lastActionTime = this.getLastActionTime();
        result = result * 59 + ($lastActionTime == null ? 43 : ((Object)$lastActionTime).hashCode());
        String $lastRoomId = this.getLastRoomId();
        result = result * 59 + ($lastRoomId == null ? 43 : $lastRoomId.hashCode());
        Timestamp $lastRoomTime = this.getLastRoomTime();
        result = result * 59 + ($lastRoomTime == null ? 43 : ((Object)$lastRoomTime).hashCode());
        return result;
    }

    public String toString() {
        return "RollCallEmployeeEntity(id=" + this.getId() + ", rollCallId=" + this.getRollCallId() + ", rollCallPlanId=" + this.getRollCallPlanId() + ", securityStationJson=" + this.getSecurityStationJson() + ", securityDepartJson=" + this.getSecurityDepartJson() + ", createdTime=" + this.getCreatedTime() + ", calledEmployeeId=" + this.getCalledEmployeeId() + ", calledTenantUserCid=" + this.getCalledTenantUserCid() + ", lastUpdatedTenantUserCIdTime=" + this.getLastUpdatedTenantUserCIdTime() + ", calledTenantUserId=" + this.getCalledTenantUserId() + ", calledTencentUserId=" + this.getCalledTencentUserId() + ", calledOrganizationId=" + this.getCalledOrganizationId() + ", calledOrganizationName=" + this.getCalledOrganizationName() + ", calledEmployeeName=" + this.getCalledEmployeeName() + ", callType=" + this.getCallType() + ", status=" + this.getStatus() + ", lastRollCallStatusTime=" + this.getLastRollCallStatusTime() + ", lastRollCallStatusNote=" + this.getLastRollCallStatusNote() + ", actionOrganizationId=" + this.getActionOrganizationId() + ", actionOrganizationName=" + this.getActionOrganizationName() + ", actionEmployeeId=" + this.getActionEmployeeId() + ", actionEmployeeName=" + this.getActionEmployeeName() + ", lastActionTime=" + this.getLastActionTime() + ", lastRoomId=" + this.getLastRoomId() + ", lastRoomTime=" + this.getLastRoomTime() + ")";
    }
}

